#include <stdio.h>
#include <math.h>

#define MAXN 100
#define gosa .000001

typedef struct circle {
    double x, y, r;
} CICL;

typedef struct pointin3d {
    double x, y, z;
} P3D;

typedef struct hyperplane {
    double a, b, c, d;
} PLN;

CICL circ[MAXN];
P3D pt[MAXN];
PLN hp[MAXN];

int plane(P3D pt1, P3D pt2, P3D pt3, PLN *h)
{
    double a1, a2, a3, b1, b2, b3;

    a1 = pt2.x - pt1.x; a2 = pt2.y - pt1.y; a3 = pt2.z - pt1.z;
    b1 = pt3.x - pt1.x; b2 = pt3.y - pt1.y; b3 = pt3.z - pt1.z;
    (*h).a = a2 * b3 - b2 * a3;
    (*h).b = a3 * b1 - b3 * a1;
    (*h).c = a1 * b2 - b1 * a2;
    if((*h).a == .0 && (*h).b == .0 && (*h).c == .0) return 0;
    (*h).d = (*h).a * pt1.x + (*h).b * pt1.y + (*h).c * pt1.z;
    return 1;
}

main(int argc, char *argv[])
{
    int i, j, k, l, n, m = 0;
    double s;
    PLN h, h2;

    if(argc > 1) n = atoi(argv[1]);
    else n = 4;
    for(i = 0; i < n; i++) {
        scanf("%lf%lf", &pt[i].x, &pt[i].y);
	pt[i].z = pt[i].x * pt[i].x + pt[i].y * pt[i].y;
	printf("disk %f %f .1\n", pt[i].x, pt[i].y);
    }
    printf("color 0 3 0\n");
    for(i = 0; i < n - 2; i++) {
        for(j = i + 1; j < n - 1; j++) {
	    for(k = j + 1; k < n; k++) {
	        plane(pt[i], pt[j], pt[k], &h);
	        if(h.c == 0) continue;
		h.a /= h.c; h.b /= h.c; h.d /= h.c; h.c = 1.;
		for(l = 0; l < n; l++) {
		    if(l == i || l == j || l == k) continue;
		    if((s = h.a * pt[l].x + h.b * pt[l].y + h.c * pt[l].z - h.d) == 0) {
		        if(l < k) {
			    if(plane(pt[i], pt[j], pt[l], &h2) == 1 || l < j) break;
			}
			continue;
		    }
		    if(s < 0) break;
		}
		if(l == n) {
		    printf("(%f, %f)  :  ", -h.a/2, -h.b/2);
		    for(l = 0; l < n; l++) if((s = h.a * pt[l].x + h.b * pt[l].y + h.c * pt[l].z - h.d) < gosa && s > -gosa) printf("%d ", l);
		    printf("\n");
		    circ[m].x = -h.a/2; circ[m].y = -h.b/2;
		    circ[m].r = sqrt((pt[k].x - circ[m].x) * (pt[k].x - circ[m].x) + (pt[k].y - circ[m].y) * (pt[k].y - circ[m].y));
		    printf("circle %f %f %f\n", circ[m].x, circ[m].y, circ[m].r);
		    hp[m].a = h.a; hp[m].b = h.b; hp[m].c = h.c; hp[m].d = h.d; m++;
		}
	    }
	}
    }
/*
    printf("color 0 0 3\n");
*/
    for(i = 0; i < m - 1; i++) {
        for(j = i + 1; j < m; j++) {
	    int k1;
	    for(k = l = 0; k < n; k++) {
	        if((s = hp[i].a * pt[k].x + hp[i].b * pt[k].y + hp[i].c * pt[k].z - hp[i].d) < gosa && (s = hp[i].a * pt[k].x + hp[i].b * pt[k].y + hp[i].c * pt[k].z - hp[i].d) > -gosa && (s = hp[j].a * pt[k].x + hp[j].b * pt[k].y + hp[j].c * pt[k].z - hp[j].d) < gosa && (s = hp[j].a * pt[k].x + hp[j].b * pt[k].y + hp[j].c * pt[k].z - hp[j].d) > -gosa) {
		    if(l == 0) {
		        k1 = k;
			l = 1;
		    }
		    else {
		        printf("color 0 0 3\nconnect %f %f %f %f\n", pt[k].x, pt[k].y, pt[k1].x, pt[k1].y);
  		        printf("color 3 0 0\nconnect %f %f %f %f\n", circ[i].x, circ[i].y, circ[j].x, circ[j].y);
			break;
		    }
		}
	    }
	}
    }
    return 0;
}
