#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

#define NUMOFBUTTON 7
#define END 0
#define EXEC 1
#define TOP_WIDTH 468
#define TOP_HEIGHT 500
#define BUTTON_WIDTH 60
#define BUTTON_HEIGHT 26
#define CANVAS_WIDTH 460
#define CANVAS_HEIGHT 460
#define DRAW_BLACK 1
#define DRAW_WHITE 2

#define MS 13

Display *display;
char *button_name[] = {"End", "Fwd", "TnLt", "TnRt", "Up", "Down", "Fill"};
Window top;
Window buttons[NUMOFBUTTON];
GC buttonGC;
Font font;
Window canvas;
GC canvasGC;
Pixmap pixmap;
GC pmGC;
GC clearGC;

char mz[MS * MS * MS];
int dr0, dr[6], sz, pos;
XPoint pts[6];

void disp()
{
    int i, j, k;
    char c;

    for(i = 0; i < sz; i++) {
	for(j = 1; j < sz - 1; j++) {
	    for(k = 0; k < sz; k++) {
		if((c = mz[(i + j * sz) * sz + k]) == 0) fprintf(stderr, " ");
		else if(c == 1) fprintf(stderr, "*");
		else fprintf(stderr, "+");
	    }
	    fprintf(stderr, " ");
	}
	fprintf(stderr, "\n");
    }
}

int main(int argc, char *argv[])
{
    int i, j, k, p, p1, p2;
    char *server;

    if(argc > 1) {
	sz = atoi(argv[1]);
	if(sz < 5 || sz > MS || (sz % 2) == 0) exit(0);
    }
    else sz = 5;
    if(argc > 2) srand(atoi(argv[2]));
    for(i = 0; i < sz * sz; i++) mz[i] = 1;
    for( ; i < sz * sz * (sz - 1); i++) mz[i] = 3;
    for( ; i < sz * sz * sz; i++) mz[i] = 1;
    for(i = sz - 1; i < sz * sz * sz; i += sz) mz[i] = 1;
    for(i = sz; i < sz * sz * sz; i += sz) mz[i] = 1;
    for(i = 1; i < sz; i++) {
	for(j = 0; j < sz; j++) mz[i * sz * sz + j] = mz[(i + 1) * sz * sz + j - sz] = 1;
    }
    for(i = 1; i < sz - 1; i += 2) {
	for(j = 1; j < sz - 1; j += 2) {
	    for(k = 1; k < sz - 1; k += 2) mz[(i * sz + j) * sz + k] = 2;
	}
    }
    dr[0] = 2; dr[1] = 2 * sz; dr[2] = -2; dr[3] = -2 * sz; dr[4] = 2 * sz * sz; dr[5] = -2 * sz * sz;
    for(mz[p = sz * (sz + 1) + 1] = mz[p1 = sz * (sz + 1) + 3] = 4, mz[sz * (sz + 1) + 2] = 0; ; ) {
	for( ; ; ) {
	    for(i = 0; i < 10; i++) if(mz[p2 = p1 + dr[rand() % 6]] != 4) break;
	    if(i == 10 || mz[(p1 + p2) / 2] == 1) break;
	    mz[(p1 + p2) / 2] = 0;
	    mz[p1 = p2] = 4;
	}
	for( ; p < sz * sz * sz; p++) {
	    if(mz[p] != 4) continue;
	    for(i = 0; i < 6; i++) if(mz[p2 = p + dr[i]] == 2) break;
	    if(i == 6) continue;
	    mz[(p + p2) / 2] = 0;
	    mz[p1 = p2] = 4;
	    break;
	}
	if(p == sz * sz * sz) break;
    }
    for(i = sz * sz + sz; i < sz * sz * sz; i++) {
	if(mz[i] == 4) mz[i] = 0;
	else if(mz[i] > 1) mz[i] = 1;
    }
    mz[sz * sz + 1] = 1;
    mz[sz * sz * (sz - 1) - 2] = 2;
    disp();
    pos = sz * (sz + 1) + 1; dr0 = 1;

    server = NULL;
    if((display = XOpenDisplay(server)) == NULL) exit(0);
    CreateResource();
    EventLoop();
    DestroyResource();
    XCloseDisplay(display);
    return 0;
}

void drawg()
{
    int i, p1 = 230, p2 = 200, ct = 230, pos2 = pos, mz0;

    XClearWindow(display, canvas);
/*    XClearWindow(display, pixmap);
*/
    SelectColor(DRAW_BLACK);
    for(i = 0; ; i++) {
	if(mz[pos2 + dr[(dr0 + 2) % 4] / 2] == mz[pos2 + sz * sz]) {
	    XDrawLine(display, canvas, canvasGC, ct - p1, ct - p1, ct - p2, ct - p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p1, ct - p1, ct - p2, ct - p2);
	}
	if(mz[pos2 + dr[dr0] / 2] == mz[pos2 + sz * sz]) {
	    XDrawLine(display, canvas, canvasGC, ct + p1, ct - p1, ct + p2, ct - p2);
	    XDrawLine(display, pixmap, canvasGC, ct + p1, ct - p1, ct + p2, ct - p2);
	}
	if(mz[pos2 + dr[dr0] / 2] == mz[pos2 - sz * sz]) {
	    XDrawLine(display, canvas, canvasGC, ct + p1, ct + p1, ct + p2, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct + p1, ct + p1, ct + p2, ct + p2);
	}
	if(mz[pos2 + dr[(dr0 + 2) % 4] / 2] == mz[pos2 - sz * sz]) {
	    XDrawLine(display, canvas, canvasGC, ct - p1, ct + p1, ct - p2, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p1, ct + p1, ct - p2, ct + p2);
	}
	if((mz0 = mz[pos2 + dr[(dr0 + 2) % 4] / 2]) == 0) {
	    if(i > 0) {
		XDrawLine(display, canvas, canvasGC, ct - p1, ct - p1, ct - p1, ct + p1);
		XDrawLine(display, pixmap, canvasGC, ct - p1, ct - p1, ct - p1, ct + p1);
	    }
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct - p2, ct - p2, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct - p2, ct - p2, ct + p2);
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct - p2, ct - p1, ct - p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct - p2, ct - p1, ct - p2);
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct + p2, ct - p1, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct + p2, ct - p1, ct + p2);
	}
	else if(mz0 == 2) {
		XDrawLine(display, canvas, canvasGC, ct - p2, ct - p2, ct - p2, ct + p2);
		XDrawLine(display, pixmap, canvasGC, ct - p2, ct - p2, ct - p2, ct + p2);
		pts[0].x = ct - p1; pts[0].y = ct - p1; pts[1].x = ct - p2; pts[1].y = ct - p2;
		pts[2].x = ct - .97 * p1; pts[2].y = ct - .93 * p1; pts[3].x = ct - .97 * p1; pts[3].y = ct + .93 * p1; 
		pts[4].x = ct - p2; pts[4].y = ct + p2; pts[5].x = ct - p1; pts[5].y = ct + p1;
		XFillPolygon(display, canvas, canvasGC, pts, 6, Complex, CoordModeOrigin);
		XFillPolygon(display, pixmap, canvasGC, pts, 6, Complex, CoordModeOrigin);
	    }
	if((mz0 = mz[pos2 + dr[dr0] / 2]) == 0) {
	    if(i > 0) {
		XDrawLine(display, canvas, canvasGC, ct + p1, ct - p1, ct + p1, ct + p1);
		XDrawLine(display, pixmap, canvasGC, ct + p1, ct - p1, ct + p1, ct + p1);
	    }
	    XDrawLine(display, canvas, canvasGC, ct + p2, ct - p2, ct + p2, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct + p2, ct - p2, ct + p2, ct + p2);
	    XDrawLine(display, canvas, canvasGC, ct + p2, ct - p2, ct + p1, ct - p2);
	    XDrawLine(display, pixmap, canvasGC, ct + p2, ct - p2, ct + p1, ct - p2);
	    XDrawLine(display, canvas, canvasGC, ct + p2, ct + p2, ct + p1, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct + p2, ct + p2, ct + p1, ct + p2);
	}
	else if(mz0 == 2) {
		XDrawLine(display, canvas, canvasGC, ct + p1, ct - p1, ct + p1, ct + p1);
		XDrawLine(display, pixmap, canvasGC, ct + p1, ct - p1, ct + p1, ct + p1);
		pts[0].x = ct + p2; pts[0].y = ct - p2; pts[1].x = ct + p1; pts[1].y = ct - p1;
		pts[2].x = ct + 1.1 * p2; pts[2].y = ct - p2; pts[3].x = ct + 1.1 * p2; pts[3].y = ct + p2; 
		pts[4].x = ct + p1; pts[4].y = ct + p1; pts[5].x = ct + p2; pts[5].y = ct + p2;
		XFillPolygon(display, canvas, canvasGC, pts, 6, Complex, CoordModeOrigin);
		XFillPolygon(display, pixmap, canvasGC, pts, 6, Complex, CoordModeOrigin);
	    }
	if(mz[pos2 - sz * sz] == 0) {
	    if(i > 0) {
		XDrawLine(display, canvas, canvasGC, ct - p1, ct + p1, ct + p1, ct + p1);
		XDrawLine(display, pixmap, canvasGC, ct - p1, ct + p1, ct + p1, ct + p1);
	    }
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct + p2, ct + p2, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct + p2, ct + p2, ct + p2);
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct + p2, ct - p2, ct + p1);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct + p2, ct - p2, ct + p1);
	    XDrawLine(display, canvas, canvasGC, ct + p2, ct + p2, ct + p2, ct + p1);
	    XDrawLine(display, pixmap, canvasGC, ct + p2, ct + p2, ct + p2, ct + p1);
	}
	if(mz[pos2 + sz * sz] == 0) {
	    if(i > 0) {
		XDrawLine(display, canvas, canvasGC, ct - p1, ct - p1, ct + p1, ct - p1);
		XDrawLine(display, pixmap, canvasGC, ct - p1, ct - p1, ct + p1, ct - p1);
	    }
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct - p2, ct + p2, ct - p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct - p2, ct + p2, ct - p2);
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct - p2, ct - p2, ct - p1);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct - p2, ct - p2, ct - p1);
	    XDrawLine(display, canvas, canvasGC, ct + p2, ct - p2, ct + p2, ct - p1);
	    XDrawLine(display, pixmap, canvasGC, ct + p2, ct - p2, ct + p2, ct - p1);
	}
	pos2 += dr[(dr0 + 3) % 4] / 2;
	if((mz0 = mz[pos2]) > 0) {
	    pos2 -= dr[(dr0 + 3) % 4] / 2;
	    if(mz[pos2 + sz * sz] == 0) SelectColor(DRAW_WHITE);
	    else SelectColor(DRAW_BLACK);
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct - p2, ct + p2, ct - p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct - p2, ct + p2, ct - p2);
	    if(mz[pos2 + dr[dr0] / 2] == 0) SelectColor(DRAW_WHITE);
	    else SelectColor(DRAW_BLACK);
	    XDrawLine(display, canvas, canvasGC, ct + p2, ct - p2, ct + p2, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct + p2, ct - p2, ct + p2, ct + p2);
	    if(mz[pos2 - sz * sz] == 0) SelectColor(DRAW_WHITE);
	    else SelectColor(DRAW_BLACK);
	    XDrawLine(display, canvas, canvasGC, ct + p2, ct + p2, ct - p2, ct + p2);
	    XDrawLine(display, pixmap, canvasGC, ct + p2, ct + p2, ct - p2, ct + p2);
	    if(mz[pos2 + dr[(dr0 + 2) % 4] / 2] == 0) SelectColor(DRAW_WHITE);
	    else SelectColor(DRAW_BLACK);
	    XDrawLine(display, canvas, canvasGC, ct - p2, ct + p2, ct - p2, ct - p2);
	    XDrawLine(display, pixmap, canvasGC, ct - p2, ct + p2, ct - p2, ct - p2);
	    if(mz0 > 1) {
		XDrawString(display, canvas, canvasGC, 220, 220, "Exit", 4);
		XDrawString(display, pixmap, canvasGC, 220, 220, "Exit", 4);
		XDrawLine(display, canvas, canvasGC, ct + p2, ct - p2, ct + p2, ct + p2);
		XDrawLine(display, pixmap, canvasGC, ct + p2, ct - p2, ct + p2, ct + p2);
		pts[0].x = ct - p2; pts[0].y = ct - p2; pts[1].x = ct + p2; pts[1].y = ct - p2;
		pts[2].x = ct - .9 * p2; pts[2].y = ct - .9 * p2; pts[3].x = ct - .9 * p2; pts[3].y = ct + .9 * p2; 
		pts[4].x = ct + p2; pts[4].y = ct + p2; pts[5].x = ct - p2; pts[5].y = ct + p2;
		XFillPolygon(display, canvas, canvasGC, pts, 6, Complex, CoordModeOrigin);
		XFillPolygon(display, pixmap, canvasGC, pts, 6, Complex, CoordModeOrigin);
	    }
	    break;
	}
	p1 = p2; p2 = (double)p2 * .8;
    }
}

CreateResource()
{
    int x, i;
    Cursor cursor;

    top = XCreateSimpleWindow(display, DefaultRootWindow(display), 0, 0, TOP_WIDTH, TOP_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));
    XStoreName(display, top, "Graphic Drawing");
    x = 2;
    cursor = XCreateFontCursor(display, XC_coffee_mug);
    XDefineCursor(display, top, cursor);
    for(i = 0; i < NUMOFBUTTON; i++, x += BUTTON_WIDTH + 10) 
        buttons[i] = XCreateSimpleWindow(display, top, x, 2, BUTTON_WIDTH, BUTTON_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));
    cursor = XCreateFontCursor(display, XC_hand1);
    for(i = 0; i < NUMOFBUTTON; i++) XDefineCursor(display, buttons[i], cursor);
    canvas = XCreateSimpleWindow(display, top, 2, 34, CANVAS_WIDTH, CANVAS_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));

    XSelectInput(display, top, KeyPressMask);
    for(i = 0; i < NUMOFBUTTON; i++) XSelectInput(display, buttons[i], ExposureMask | ButtonPressMask);
    XSelectInput(display, canvas,  ExposureMask | ButtonPressMask);

    buttonGC = XCreateGC(display, top, 0, 0);
    XSetForeground(display, buttonGC, BlackPixel(display, DefaultScreen(display)));
    canvasGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, canvasGC, BlackPixel(display, DefaultScreen(display)));

    font = XLoadFont(display, "12x24");
    XSetFont(display, buttonGC, font);
    XSetFont(display, canvasGC, font);

    XMapWindow(display, top);
    XMapSubwindows(display, top);

    pixmap = XCreatePixmap(display, canvas, CANVAS_WIDTH, CANVAS_HEIGHT, 
			   DefaultDepth(display, DefaultScreen(display)));
    clearGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, clearGC, WhitePixel(display, DefaultScreen(display)));
    XFillRectangle(display, pixmap, clearGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    pmGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, pmGC, BlackPixel(display, DefaultScreen(display)));
    XSetBackground(display, pmGC, WhitePixel(display, DefaultScreen(display)));
}

EventLoop()
{
    XEvent event;
    void drawg(), ReDraw();

    XNextEvent(display, &event); ReDraw(&event);
    drawg();
/*    Xflush(display);
*/    for(;;) {
        XNextEvent(display, &event);
	switch(event.type)
	{
	case Expose: ReDraw(&event); break;
	case ButtonPress: if(HitButton(&event) == END) return; break;
	}
    }
}

void ReDraw(event)
    XExposeEvent *event;
{
    int i;

    for(i = 0; i < NUMOFBUTTON; i++) {
        if(event->window == buttons[i]) {
	    XDrawString(display, buttons[i], buttonGC, 1, 23, 
			button_name[i], strlen(button_name[i]));
	    return;
	}
	if(event->window == canvas) {
/*	    XCopyArea(display, pixmap, canvas, pmGC,
		      event->x, event->y, event->width, event->height, event->x, event->y);
*/
	    drawg();
	}
    }
}

HitButton(event)
    XButtonEvent *event;
{
    int button;
    void drawg();

    if(event->button == Button1) {
        for(button = 0; button < NUMOFBUTTON; button++) {
	    if(event->window == buttons[button]) {
	        if(button == 0) return END;
	        if(button == 1) {
		    if(mz[pos + (dr[(dr0 + 3) % 4] / 2)] == 0) pos += dr[(dr0 + 3) % 4] / 2;
		}
		else if(button == 2) {
		    dr0 += 3; dr0 %= 4;
		}
		else if(button == 3) {
		    dr0 += 1; dr0 %= 4;
		}
		else if(button == 4) {
		    if(mz[pos + sz * sz] == 0) pos += sz * sz;
		}
		else if(button == 5) {
		    if(mz[pos - sz * sz] == 0) pos -= sz * sz;
		}
		else if(button == 6) mz[pos] = 1;
		drawg();
		return EXEC;
	    }
	}
    }
    return EXEC;
}

SelectColor(color)
    int color;
{
    switch(color) {
        case DRAW_BLACK: XSetForeground(display, canvasGC, BlackPixel(display, DefaultScreen(display))); break;
        case DRAW_WHITE: XSetForeground(display, canvasGC, WhitePixel(display, DefaultScreen(display))); break;
    }
}

DestroyResource()
{
    XUnloadFont(display, font);
    XFreeGC(display, buttonGC);
    XFreeGC(display, canvasGC);
    XFreeGC(display, pmGC);
    XFreeGC(display, clearGC);
    XFreePixmap(display, pixmap);
    XDestroySubwindows(display, top);
    XDestroyWindow(display, top);
}

