#include "planegeometry.h"
#include <math.h>

double s[] = {0.1, 1.5, 3.2, 0.5, 2.3};
POINT A[3], A2[3], P, D[3];

int main(int argc, char *argv[])
{
	int i;
	POINT O;
	LINE l;

	for(i = 0; i < 5; i++) {
		if(argc < i + 2) break;
		s[i] = atof(argv[i + 1]);
	}
	O.x = O.y = 0;
	for(i = 0; i < 3; i++) {
		A[i].x = cos(s[i]);
		A[i].y = sin(s[i]);
	}
	A2[0].x = cos(s[3]);
	A2[0].y = sin(s[3]);
	P.x = cos(s[4]);
	P.y = sin(s[4]);
	printf("gray 0.5\n");
	for(i = 0; i < 3; i++) WRITE(A[i] * A[(i + 1) % 3]);
	printf("gray 0.\n");
	printf("circle 0 0 1\nconnect %f %f %f %f %f %f %f %f\n", A[0].x, A[0].y, A[1].x, A[1].y, A[2].x, A[2].y, A[0].x, A[0].y);
	printf("color 0 0 3\n");
	l = A[0] * A2[0];
	for(i = 1; i < 3; i++) {
		LINE m = A[i] / l;
		POINT M = (O | m) * m;
		A2[i].x = 2 * M.x - A[i].x;
		A2[i].y = 2 * M.y - A[i].y;
	}
	for(i = 0; i < 3; i++) printf("connect %f %f %f %f\n", A[i].x, A[i].y, A2[i].x, A2[i].y);
	printf("color 0 2 3\n");
	for(i = 0; i < 3; i++) {
		LINE m = P * A2[i];
		WRITE(m);
		D[i] = m * (A[(i + 1) % 3] * A[(i + 2) % 3]);
	}
	printf("color 3 0 0\n");
	WRITE(D[0] * D[1]);
	return 0;
}
