#include "planegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
	int i;
	double t, x, y, x0, y0;
	LINE l;
	CIRC c;

	x0 = 3; y0 = 0;
	printf("circle 0 0 1\ncircle 0 0 3\ncolor 0 0 3\n");
	for(t = 0; t < 2 * M_PI; t += 0.1) {
		x = 2 * cos(t) + cos(2 * t);
		y = 2 * sin(t) - sin(2 * t);
		printf("connect %f %f %f %f\n", x, y, x0, y0);
		x0 = x; y0 = y;
	}
	for(i = 1; i < argc; i++) {
		t = atof(argv[i]);
		l.a = sin(t / 2.); l.b = cos(t / 2.);
		l.c = -l.a * cos(t) - l.b * sin(t);
		printf("color 3 0 0\n");
		WRITE(l);
		printf("gray 0.5\n");
		c.c.x = 2 * cos(t); c.c.y = 2 * sin(t);
		c.r = 1.;
		WRITE(c);
	}
	if(argc > 1) t = atof(argv[1]);
	else t = 0.5;
	x = 2 * cos(t); y = 2 * sin(t);
	printf("gray 0.\ncircle %f %f 1.\n", x, y);
	return 0;
}
