#include "planegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
	int i;
	double t, x, y, x0, y0;
	LINE l;
	CIRC c;

	x0 = 3; y0 = 0;
	printf("circle 0 0 1\n");
	for(t = 0; t < 2 * M_PI; t += 0.1) {
		x = 2 * cos(t) + cos(2 * t);
		y = 2 * sin(t) - sin(2 * t);
		printf("connect %f %f %f %f\n", x, y, x0, y0);
		x0 = x; y0 = y;
	}
	printf("color 0 0 3\n");
	for(i = 0; i < argc; i++) {
		if(i == 0) t = -M_PI / 3.;
		else t = atof(argv[i]);
		x0 = cos(t);
		y0 = sin(t);
		printf("connect 0. 0. %f %f %f %f\n", x0, y0, x0 + 2. * cos(0.5 * t), y0 + 2. * sin(-0.5 * t));
		printf("connect %f %f %f %f\n", x0, y0, x0 - 2. * cos(0.5 * t), y0 - 2. * sin(-0.5 * t));
	}
	printf("color 3 0 0\ncircle 0 0 2\n");
	for(i = 0; i < argc; i++) {
		if(i == 0) t = -M_PI / 3.;
		else t = atof(argv[i]);
		l.a = cos(0.5 * t);
		l.b = -sin(0.5 * t);
		l.c = 0.;
		WRITE(l);
		l.c = 2.;
		WRITE(l);
		l.c = -2.;
		WRITE(l);
	}
	return 0;
}
