#include "planegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
	int i;
	double t, x, y, x0, y0, a, b, c, d, f;
	LINE l;

	x0 = 3; y0 = 0;
	printf("circle 0 0 1\n");
	for(t = 0; t < 2 * M_PI; t += 0.1) {
		x = 2 * cos(t) + cos(2 * t);
		y = 2 * sin(t) - sin(2 * t);
		printf("connect %f %f %f %f\n", x, y, x0, y0);
		x0 = x; y0 = y;
	}
	if(argc > 1) x0 = atof(argv[1]);
	else x0 = 0.7;
	if(argc > 2) y0 = atof(argv[2]);
	else y0 = 0.5;
	if(y0 > 0.) f = 1.;
	printf("color 0 0 3\n");
	for(t = 0; t < 2 * M_PI; t += 0.001) {
		a = sin(t);
		b = cos(t);
		c = sin(3 * t);
		if((d = a * x0 + b * y0 - c) * f < 0.) {
			//if(((d = a * x0 + b * y0 - c) < 0.05) && (d > - 0.05)) {
			//l.a = a; l.b = b; l.c = -c;
			//WRITE(l);
			printf("connect %f %f %f %f\n", x0, y0, cos(2 * t) + 2. * cos(t), sin(2 * t) - 2. * sin(t));
			fprintf(stderr, "%f\n", t);
			f = d;
		}
	}
	return 0;
}
