#include "planegeometry.h"
#include <math.h>

POINT v[3];
LINE m, l[3];

POINT isp(double t)
{
	LINE n[2];
	int i;

	m.a = cos(t);
	m.b = sin(t);
	//WRITE(m);
	for(i = 0; i < 2; i++) {
		n[i] = ((v[i] | m) * m) | l[i];
	}
	return n[0] * n[1];
}
	
POINT isp2(POINT G, double t)
{
	LINE n[2];
	int i;

	m.a = cos(t);
	m.b = sin(t);
	m.c = -(m.a * G.x + m.b * G.y);
	for(i = 0; i < 2; i++) {
		n[i] = ((v[i] | m) * m) | l[i];
	}
	return n[0] * n[1];
}
	
int main(int argc, char *argv[])
{
	int i;
	double t, s[3];
	POINT P, P0, G;

	if(argc > 1) s[0] = atof(argv[1]);
	else s[0] = 0.;
	if(argc > 2) s[1] = atof(argv[2]);
	else s[1] = 1.8;
	if(argc > 3) s[2] = atof(argv[3]);
	else s[2] = 4.;
	if(argc > 4) G.x = atof(argv[4]);
	else G.x = 0.5;
	if(argc > 5) G.y = atof(argv[5]);
	else G.y = 0.3;
	for(i = 0; i < 3; i++) {
		v[i].x = cos(s[i]);
		v[i].y = sin(s[i]);
	}
	for(i = 0; i < 3; i++) {
		l[i] = v[(i + 1) % 3] * v[(i + 2) % 3];
		WRITE(l[i]);
	}
	m.c = -1.;
	printf("color 0 0 3\n");
	P0 = isp(0.);
	for(t = 0.03; t < 6.3; t += 0.03) {
		P = isp(t);
		WRITE(P0, P);
		P0 = P;
	}
	printf("color 3 0 0\n");
	P0 = isp2(G, 0.);
	for(t = 0.03; t < 6.3; t += 0.03) {
		P = isp2(G, t);
		WRITE(P0, P);
		P0 = P;
	}
	return 0;
}
