#include "planegeometry.h"
#include <math.h>
#include <string.h>

int main(int argc, char *argv[])
{
	POINT P1,P2, P3, Q1, Q2, Q3;
	LINE l12, l13, l21, l23, l31, l32;
	short f, g = 0;
	double s12, s13, s21, s23, s31, s32, t;

	//	fprintf(stderr, "Im called as %s\n", argv[0]);
	if(strcmp(argv[0], "./Morley1") == 0) g = 1;
	else if(strcmp(argv[0], "./Morley2") == 0) g = 2;
	else if(strcmp(argv[0], "./Morley4") == 0) g = 4;
	else if(strcmp(argv[0], "./Morley5") == 0) g = 5;
	else if(strcmp(argv[0], "./Morley8") == 0) g = 8;
	else if(strcmp(argv[0], "./Morley13") == 0) g = 13;
	else if(strcmp(argv[0], "./Morley14") == 0) g = 14;
	else if(strcmp(argv[0], "./Morley17") == 0) g = 17;
	else if(strcmp(argv[0], "./Morley26") == 0) g = 26;
	if(argc >= 3) {
		P1.x = atof(argv[1]);
		P1.y = atof(argv[2]);
	}
	else {	P1.x = 1.; P1.y = -1.8;}
	if(argc >= 5) {
		P2.x = atof(argv[3]);
		P2.y = atof(argv[4]);
	}
	else {	P2.x = -3.; P2.y = 0.;}
	if(argc >= 7) {
		P3.x = atof(argv[5]);
		P3.y = atof(argv[6]);
	}
	else {	P3.x = 2.5; P3.y = 2.;}
	WRITE(P1, P2, P3);
	s12 = atan2(P2.y - P1.y, P2.x - P1.x);
	s13 = atan2(P3.y - P1.y, P3.x - P1.x);
	s21 = atan2(P1.y - P2.y, P1.x - P2.x);
	s23 = atan2(P3.y - P2.y, P3.x - P2.x);
	s31 = atan2(P1.y - P3.y, P1.x - P3.x);
	s32 = atan2(P2.y - P3.y, P2.x - P3.x);
	f = g % 3;
	if(f == 0) {
		if(s12 - s13 > M_PI) s12 -= 2 * M_PI;
		else if(s12 - s13 < -M_PI) s12 += 2 * M_PI;
	}
	else if(f == 1) {
		if((t = s12 - s13) > 0.) {
			if(t < M_PI) s12 -= 2 * M_PI;
		}
		else if(t > -M_PI) s12 += 2 * M_PI;
	}
	else {
		if(s12 - s13 > 0.) s12 -= M_PI;
		else s12 += M_PI;
	}
	l12.a = sin((2. * s12 + s13) / 3.);
	l12.b = -cos((2. * s12 + s13) / 3.);
	l12.c = -l12.a * P1.x - l12.b * P1.y;
	l13.a = sin((s12 + 2. * s13) / 3.);
	l13.b = -cos((s12 + 2. * s13) / 3.);
	l13.c = -l13.a * P1.x - l13.b * P1.y;
	f = (g / 3) % 3;
	if(f == 0) {
		if(s21 - s23 > M_PI) s21 -= 2 * M_PI;
		else if(s21 - s23 < -M_PI) s21 += 2 * M_PI;
	}
	else if(f == 1) {
		if((t = s21 - s23) > 0.) {
			if(t < M_PI) s21 -= 2 * M_PI;
		}
		else if(t > -M_PI) s21 += 2 * M_PI;
	}
	else {
		if(s21 - s23 > 0.) s21 -= M_PI;
		else s21 += M_PI;
	}
	l21.a = sin((2. * s21 + s23) / 3.);
	l21.b = -cos((2. * s21 + s23) / 3.);
	l21.c = -l21.a * P2.x - l21.b * P2.y;
	l23.a = sin((2. * s23 + s21) / 3.);
	l23.b = -cos((2. * s23 + s21) / 3.);
	l23.c = -l23.a * P2.x - l23.b * P2.y;
	f = g / 9;
	if(f == 0) {
		if(s31 - s32 > M_PI) s31 -= 2 * M_PI;
		else if(s31 - s32 < -M_PI) s31 += 2 * M_PI;
	}
	else if(f == 1) {
		if((t = s31 - s32) > 0.) {
			if(t < M_PI) s31 -= 2 * M_PI;
		}
		else if(t > -M_PI) s31 += 2 * M_PI;
	}
	else {
		if(s31 - s32 > 0.) s31 -= M_PI;
		else s31 += M_PI;
	}
	l31.a = sin((2. * s31 + s32) / 3.);
	l31.b = -cos((2. * s31 + s32) / 3.);
	l31.c = -l31.a * P3.x - l31.b * P3.y;
	l32.a = sin((2. * s32 + s31) / 3.);
	l32.b = -cos((2. * s32 + s31) / 3.);
	l32.c = -l32.a * P3.x - l32.b * P3.y;
	//	printf("%f %f\n", s12, s13);
	printf("color 0 0 3\n");
	//	WRITE(l12); WRITE(l13); WRITE(l21);
	Q3 = l12 * l21; Q2 = l13 * l31; Q1 = l23 * l32;
	WRITE(P1, Q3); WRITE(P2, Q3); 
	WRITE(P1, Q2); WRITE(P3, Q2); 
	WRITE(P2, Q1); WRITE(P3, Q1);
	printf("color 3 0 0\n");
	WRITE(Q1, Q2, Q3);
	fprintf(stderr, "%f %f %f\n", Q1 + Q2, Q2 + Q3, Q3 + Q1);
	return 0;
}
