#include "planegeometry.h"
#include <math.h>

POINT anop(POINT A)
{
	POINT B;
	double a, b;

	a = A.x / (A.y - 2.5);
	b = a * A.y - A.x;
	B.y = 2. * a * b / (a * a + 1.) - A.y;
	B.x = a * (B.y - A.y) + A.x;
	return B;
}

int main(int argc,  char *argv[])
{
	POINT A, B, C, D, E, F, P, Q, R;
	LINE ab, bc, cd, de, ef, fa;
	double t;

	if(argc > 1) t = atof(argv[1]);
	else t = 1.4;
	printf("circle 0. 0. 1.\n");
	A.x = cos(t);
	A.y = sin(t);
	D = anop(A);
	C.x = cos(1.); C.y = sin(1.);
	F = anop(C);
	E.x = cos(2.23); E.y = sin(2.23);
	B = anop(E);
	WRITE(ab = A * B);
	WRITE(cd = C * D);
	WRITE(ef = E * F);
	WRITE(bc = B * C);
	WRITE(de = D * E);
	WRITE(fa = F * A);
	printf("color 3 0 0\n");
	P = ab * de;
	Q = bc * ef;
	R = cd * fa;
	WRITE(P * Q);
	WRITE(P); WRITE(Q); WRITE(R);
	//	printf("gray 0.5\n");
	printf("color 0 3 3\n");
	WRITE(A * D);
	WRITE(B * E);
	WRITE(C * F);
	printf("color 0 0 3\n");
	WRITE(A); WRITE(C); WRITE(E);
	WRITE(A * C);
	WRITE(A * E);
	printf("color 0 3 0\n");
	WRITE(B); WRITE(D); WRITE(F);
	WRITE(D * F);
	WRITE(D * B);
	printf("color 3 2 0\n");
	WRITE(P * F);
	WRITE(Q * D);
	WRITE(R * B);
	printf("color 3 0 3\n");
	WRITE(P * C);
	WRITE(Q * A);
	WRITE(R * E);
	return 0;
}
