#include "planegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
	int i, adp = 1;
	double t, x0, y0, x1, y1, ct, st, xy;
	POINT A[3], P, Q;
	LINE l, m[3];

	if(argc < 4) {
		A[0].x = cos(0.1); A[0].y = sin(0.1);
		A[1].x = cos(1.5); A[1].y = sin(1.5);
		A[2].x = cos(3.2); A[2].y = sin(3.2);
	}
	else {
		for(i = 0; i < 3; i++) {
			t = atof(argv[i+1]);
			A[i].x = cos(t);
			A[i].y = sin(t);
		}
	}
	if(argc < 5) {
		Q.x = cos(4.); Q.y = sin(4.);
	}
	else {
		t = atof(argv[4]);
		Q.x = cos(t);
		Q.y = sin(t);
	}
	printf("gray 0.5\ncircle 0 0 1\n");
	printf("gray 0.7\n");
	WRITE(m[0] = A[0] * A[1]);
	WRITE(m[1] = A[1] * A[2]);
	WRITE(m[2] = A[2] * A[0]);
	printf("gray 0\n");
	WRITE(A[0], A[1]); WRITE(A[1], A[2]); WRITE(A[2], A[0]);
	x0 = y0 = 1.;
	printf("color 3 1 0\n");
	for(t = 0.001; t < 2 * M_PI; t += 0.001) {
		P.x = cos(t);
		P.y = sin(t);
		/*
		Q.x = cos(t + 1.);
		Q.y = sin(t + 1.);
		*/
		l = (((Q % m[0]) * P) * m[0]) * (((Q % m[1]) * P) * m[1]);
		x1 = -l.a / l.c; y1 = -l.b / l.c;
		xy = x0 * y1 - x1 * y0;
		printf("point %f %f\n", (y1 - y0) / xy, (x0 - x1) / xy);
		x0 = x1; y0 = y1;
	}
	return 0;
}
