#include "planegeometry.h"
#include <math.h>

double s[] = {0.1, 2.5, 5.2, 3.5, 4.3};
POINT A[3], B[3], P, Q;
LINE l[3];

int main(int argc, char *argv[])
{
	int i;

	for(i = 1; i < argc; i++) s[i-1] = atof(argv[i]);
	for(i = 0; i < 3; i++) {
		A[i].x = cos(s[i]);
		A[i].y = sin(s[i]);
	}
	P.x = cos(s[3]);
	P.y = sin(s[3]);
	Q.x = cos(s[4]);
	Q.y = sin(s[4]);
	printf("circle 0 0 1\n");
	for(i = 0; i < 3; i++) WRITE(l[i] = A[(i+1) % 3] * A[(i+2) % 3]);
	printf("gray 0.7\n");
	for(i = 0; i < 3; i++) {
		B[i] = ((P % l[i]) * Q) * l[i];
		WRITE(P, B[i]);
		WRITE(Q, B[i]);
	}
	printf("color 0 0 3\n");
	WRITE(B[0] * B[1]);
	return 0;
}
