#include "planegeometry.h"
#include <math.h>

double s[] = {0.1, 1.5, 3.2};
POINT P[3], Q;
LINE l[3], m;

int main(int argc, char *argv[])
{
	int i;
	double t, x, y, x0, y0;

	if(argc > 1) s[0] = atof(argv[1]);
	if(argc > 2) s[1] = atof(argv[2]);
	if(argc > 3) s[2] = atof(argv[3]);
	for(i = 0; i < 3; i++) {
		P[i].x = cos(s[i]);
		P[i].y = sin(s[i]);
	}
	l[0] = P[0] * P[1]; l[1] = P[1] * P[2]; l[2] = P[2] * P[0];
	printf("circle 0 0 1\nconnect %f %f %f %f %f %f %f %f\n", P[0].x, P[0].y, P[1].x, P[1].y, P[2].x, P[2].y, P[0].x, P[0].y);
	printf("color 0 0 3\n");
	Q.x = 1.; Q.y = 0.;
	m = ((Q | l[0]) * l[0]) * ((Q | l[1]) * l[1]);
	x0 = m.a / m.c; y0 = m.b / m.c;
	for(t = 0; t < 2 * M_PI; t += 0.1) {
		Q.x = cos(t); Q.y = sin(t);
		if((t - s[1] > -0.2) && (t - s[1] < 0.2)) m = ((Q | l[0]) * l[0]) * ((Q | l[2]) * l[2]);
		else m = ((Q | l[0]) * l[0]) * ((Q | l[1]) * l[1]);
		x = m.a / m.c; y = m.b / m.c;
		if((x - x0) * (x - x0) + (y - y0) * (y - y0) < 100.) printf("connect %f %f %f %f\n", x0, y0, x, y);
		x0 = x; y0 = y;
	}
	printf("color 3 0 0\n");
	t = (s[0] + s[1] + s[2]) / 3.;
	Q.x = cos(t); Q.y = sin(t);
	m = ((Q | l[0]) * l[0]) * ((Q | l[1]) * l[1]);
	x = m.a / m.c; y = m.b / m.c;
	printf("disk %f %f 0.1\n", x, y);
	t += 2 * M_PI / 3;
	Q.x = cos(t); Q.y = sin(t);
	m = ((Q | l[0]) * l[0]) * ((Q | l[1]) * l[1]);
	x = m.a / m.c; y = m.b / m.c;
	printf("disk %f %f 0.1\n", x, y);
	t += 2 * M_PI / 3;
	Q.x = cos(t); Q.y = sin(t);
	m = ((Q | l[0]) * l[0]) * ((Q | l[1]) * l[1]);
	x = m.a / m.c; y = m.b / m.c;
	printf("disk %f %f 0.1\n", x, y);
	return 0;
}
