#include "planegeometry.h"
#include "poly.h"
#include <math.h>

double s[] = { 0.1, 1.5, 3.2};
POINT P[3], Q;
LINE l[3], m;
P1 E[9];
P3 F[3], G;

int main(int argc, char *argv[])
{
	int i;

	if(argc > 1) s[0] = atof(argv[1]);
	if(argc > 2) s[1] = atof(argv[2]);
	if(argc > 3) s[2] = atof(argv[3]);
	for(i = 0; i < 3; i++) {
		P[i].x = cos(s[i]);
		P[i].y = sin(s[i]);
	}
	l[0] = P[0] * P[1]; l[1] = P[1] * P[2]; l[2] = P[2] * P[0];
	for(i = 0; i < 3; i++) {
		E[i * 3].x = -l[i].b * l[i].b;
		E[i * 3].y = E[i * 3 + 1].x = l[i].a * l[i].b;
		E[i * 3 + 1].y = -l[i].a * l[i].a;
		E[i * 3].c = E[i * 3 + 1].c = 0.;
		E[i * 3 + 2].x = l[i].a * l[i].c;
		E[i * 3 + 2].y = l[i].b * l[i].c;
		E[i * 3 + 2].c = -l[i].a * l[i].a - l[i].b * l[i].b;
	}
	F[0] = p2xp1(p2mp2(p1xp1(E[0], E[4]), p1xp1(E[1], E[3])), E[8]);
	F[1] = p2xp1(p2mp2(p1xp1(E[3], E[7]), p1xp1(E[4], E[6])), E[2]);
	F[2] = p2xp1(p2mp2(p1xp1(E[6], E[1]), p1xp1(E[7], E[0])), E[5]);
	G = p3pp3(p3pp3(F[0], F[1]), F[2]);
	printf("circle 0 0 1\nconnect %f %f %f %f %f %f %f %f\n", P[0].x, P[0].y, P[1].x, P[1].y, P[2].x, P[2].y, P[0].x, P[0].y);
	printf("color 0 0 3\n");
	printf("curve %fx3+%fx2y+%fxy2+%fy3+%fx2+%fxy+%fy2+%fx+%fy+%f\n", G.x3, G.x2y, G.xy2, G.y3, G.x2, G.xy, G.y2, G.x, G.y, G.c);
	return 0;
}
