#include "planegeometry.h"
#include <math.h>

main(int argc, char *argv[])
{
    POINT A, B, C, ab, ac, bc, ABc, BCa, CAb, A2, B2, C2;
    LINE a, b, c, AB, AC, BC, Abc, Bca, Cab, a2, b2, c2;
	double t[3], nr;
	int i;

	if(argc < 4) return 1;
	for(i = 0; i < 3; i++) t[i] = atof(argv[i + 1]);
	A.x = a.a = cos(t[0]); A.y = a.b = sin(t[0]);
	B.x = b.a = cos(t[1]); B.y = b.b = sin(t[1]);
	C.x = c.a = cos(t[2]); C.y = c.b = sin(t[2]);
	a.c = b.c = c.c = -1.;
	printf("circle 0 0 1\n");
	WRITE(a); WRITE(b); WRITE(c);
	printf("color 0 0 3\n");
	WRITE(AB = A * B); WRITE(AC = A * C); WRITE(BC = B * C);
	ab = a * b; bc = b * c; ac = a * c;
	printf("color 3 0 0\n");
	Abc = A * bc; Bca = B * ac; Cab = C * ab;
	ABc = AB * c; BCa = BC * a; CAb = AC * b;
	WRITE(ABc * BCa); 
	printf("color 0 2 3\n");
	WRITE(Abc); WRITE(Bca); WRITE(Cab);
	printf("color 3 2 0\n");
	nr = Abc.a * Abc.a + Abc.b * Abc.b;
	A2.x = a2.a = -2. * Abc.a * Abc.c / nr - A.x; A2.y = a2.b = -2. * Abc.b * Abc.c / nr - A.y;
	nr = Bca.a * Bca.a + Bca.b * Bca.b;
	B2.x = b2.a = -2. * Bca.a * Bca.c / nr - B.x; B2.y = b2.b = -2. * Bca.b * Bca.c / nr - B.y;
	nr = Cab.a * Cab.a + Cab.b * Cab.b;
	C2.x = c2.a = -2. * Cab.a * Cab.c / nr - C.x; C2.y = c2.b = -2. * Cab.b * Cab.c / nr - C.y;
	a2.c = b2.c = c2.c = -1.;
	/*	printf("color 3 0 0\n");
	printf("disk %f %f .1\n", A2.x, A2.y);
	*/
	WRITE(a2); WRITE(b2); WRITE(c2);
	printf("color 3 3 0\n");
	WRITE(A2 * B2); WRITE(B2 * C2); WRITE(C2 * A2);
	return 0;
}
