#include "planegeometry.h"
#include <math.h>

#define MD 10
#define gosa .0000000000001

double vofft(int d, double c[], double x)
{
	int i;
	double v, xx;

	v = c[d];
	for(i = d - 1, xx = 1.; i >= 0; i--) {
		xx *= x;
		v += c[i] * xx;
	}
	return v;
}

double fdz(int d, double c[], double x1, double x2)
{
	double x, y, y1, y2, s;

	y1 = vofft(d, c, x1);
	y2 = vofft(d, c, x2);
	if(y1 * y2 > 0.) {
		fprintf(stderr, "y1 = %f, y2 = %f\n", y1, y2);
		return gosa;
	}
	for( ; ; ) {
		x = (x1 + x2) / 2.;
		if(x > 100) {
			if(((x1 - x) / x) < gosa) break;
		}
		else if(x < -100) {
			if(((x1 - x) / (-x)) < gosa) break;
		}
		else if(((s = x - x1) < gosa) && (s > -gosa)) break;
		y = vofft(d, c, x);
		//if((y > -gosa) && (y < gosa)) break;
		if(y * y1 > 0.) x1 = x;
		else x2 = x;
	}
	return x;
}

int fdasex(int d, double c[], double z[])
{
	int i, n, n2;
	double x0, x1, x2, y1, y2, c2[MD], z2[MD], f;

	if(d == 1) {
		z[0] = -c[1] / c[0];
		return 1;
	}
	for(i = 0; i < d; i++) c2[i] = (d - i) * c[i];
	n2 = fdasex(d - 1, c2, z2);
	if(n2 == 0) {
		y1 = vofft(d, c, 0.);
		if(y1 > gosa) {
			for(x2 = -10.; vofft(d, c, x2) > 0.; ) x2 *= 10.;
			z[0] = fdz(d, c, 0., x2);
		}
		else if(y1 < -gosa) {
			for(x1 = 10.; vofft(d, c, x1) < 0.; ) x1 *= 10.;
			z[0] = fdz(d, c, x1, 0.);
		}
		else z[0] = 0.;
		return 1;
	}
	x1 = z2[0]; y1 = vofft(d, c, x1);
	if(y1 < 0.) {
		if(x1 > 10.) x2 = x1 + 10.;
		else x2 = 10.;
		for(x0 = x1; vofft(d, c, x2) < 0.; x2 *= 10.) x0 = x2;
		z[0] = fdz(d, c, x2, x0);
		n = 1;
	}
	else n = 0;
	for(i = 1; i < n2; i++) {
		if((y1 < gosa) && (y1 > -gosa)) {
			z[n++] = x1;
			x1 = z2[i];
			y1 = vofft(d, c, x1);
			continue;
		}
		x2 = z2[i];
		y2 = vofft(d, c, x2);
		if(y1 * y2 < 0.) z[n++] = fdz(d, c, x1, x2);
		x1 = x2; y1 = y2;
	}
	if((y1 < gosa) && (y1 > -gosa)) z[n++] = x1;
	else {
		if((d % 2) == 0) f = 1.;
		else f = -1.;
		if(y1 * f < 0.) {
			if(x1 < -10.) x2 = x1 - 10.;
			else x2 = -10.;
			for(x0 = x1; vofft(d, c, x2) * f < 0.; x2 *= 10.) x0 = x2;
			z[n++] = fdz(d, c, x0, x2);
		}
	}
	return n;
}
	
int fdallsol(int d, double c[], double z[])
{
	int i;

	for( ; *c == 0.; c++) d--;
	if(d < 1) return 0;
	for(i = 1; i <= d; i++) c[i] /= c[0];
	c[0] = 1.;
	return fdasex(d, c, z);
}

void drawq(double e[])
{
	int i, f;
	double a, b, c, D, x, dx = 0.01, x0, yu, yd, yu0, yd0, srD;

	x0 = -3.005;
	a = e[2]; b = x0 * e[1] + e[4]; c = x0 * (x0 * e[0] + e[3]) + e[5];
	if(a == 0.) {
		yu0 = -c / b;
		for(x = x0 + dx; x < 3.; x += dx) {
			if((b = x * e[1] + e[4]) == 0.) continue;
			yu = -(x * (x * e[0] + e[3]) + e[5]) / b;
			if(yu0 * yu > -1.) printf("connect %f %f %f %f\n", x0, yu0, x, yu);
			x0 = x; yu0 = yu;
		}
	}
	else {
		D = b * b - 4. * a * c;
		if(D < 0.) f = -1;
		else {
			f = 1;
			srD = sqrt(D);
			yu0 = 0.5 * (-b + srD) / a;
			yd0 = 0.5 * (-b - srD) / a;
		}
		for(x = x0 + dx; x < 3.; x += dx) {
			b = e[1] * x + e[4]; c = x * (e[0] * x + e[3]) + e[5];
			D = b * b - 4. * a * c;
			if(D < 0.) {
				if(f == 1) {
					printf("connect %f %f %f %f\n", x0, yu0, x0, yd0);
					f = -1;
				}
			}
			else {	
				srD = sqrt(D);
				yu = 0.5 * (-b + srD) / a;
				yd = 0.5 * (-b - srD) / a;
				if(f == 1) {
					printf("connect %f %f %f %f\n", x0, yu0, x, yu);
					printf("connect %f %f %f %f\n", x0, yd0, x, yd);
				}
				else {
					printf("connect %f %f %f %f\n", x, yu, x, yd);
					f = 1;
				}
				yu0 = yu;
				yd0 = yd;
			}
			x0 = x;
		}
	}
}

void mulpoly(int d, double a[], double b[], double c[])
{
	int i, j;

	for(i = 0; i <= 2 * d; i++) {
		if(i > d) j = i - d;
		else j = 0;
		c[i] = a[j] * b[i - j];
		for(j++; (j <= i) && (j <= d); j++) c[i] += a[j] * b[i - j];
	}
	return;
}

void addpoly(int d, double a[], double b[], double c[])
{
	int i;

	for(i = 0; i <= d; i++) c[i] = a[i] + b[i];
	return;
}

void subpoly(int d, double a[], double b[], double c[])
{
	int i;

	for(i = 0; i <= d; i++) c[i] = a[i] - b[i];
	return;
}

void ctpoly(int d, double c, double a[], double b[])
{
	int i;

	for(i = 0; i <= d; i++) b[i] = c * a[i];
	return;
}

double vofq(double p[], double x, double y)
{
	double x2 = x* x, y2 = y * y, xy = x * y;

	return p[0] * x2 + p[1] * xy + p[2] * y2 + p[3] * x + p[4] * y + p[5];
}

/*
p1[0]x^2 + p1[1]xy + p1[2]y^2 + p1[3]x + p1[4]y + p1[5] = 0
と
p2[0]x^2 + p2[1]xy + p2[2]y^2 + p2[3]x + p2[4]y + p2[5] = 0
の交点を求める。
 */
int is2q(double p1[], double p2[], POINT pt[])
{
	int i, j, l, m, n;
	double q1[3], q2[3], r1[2], r2[2], s[3], t[5], t1[3], t2[3], u[3], v[5], w[5], x[5], y[5], z[5], e[6], d[6];

	q1[0] = p1[2]; q1[1] = p1[4]; q1[2] = p1[5]; // q1 = p1[2]y2 + p1[4]y + p1[5]
	q2[0] = p2[2]; q2[1] = p2[4]; q2[2] = p2[5]; // q2 = p2[2]y2 + p2[4]y + p2[5]
	r1[0] = p1[1]; r1[1] = p1[3]; //r1 = p1[1]y + p1[3]
	r2[0] = p2[1]; r2[1] = p2[3]; //r2 = p2[1]y + p2[3]
	ctpoly(2, p2[0], q1, t1);
	ctpoly(2, p1[0], q2, t2);
	subpoly(2, t1, t2, t); // t = p2[0]q1 - p1[0]q2
	mulpoly(2, t, t, z); //z = t^2
	addpoly(2, t1, t2, u); // u = p2[0]q1 + p1[0]q2
	mulpoly(1, r1, r2, s); // s = r1 * r2
	mulpoly(2, s, u, v);
	subpoly(4, z, v, w); // w = t^2 - s * u
	mulpoly(1, r2, r2, u);
	mulpoly(2, u, q1, v); // v = r2^2 * q1
	ctpoly(4, p1[0], v, z); //z = p1[0] * r2^2 * q1
	addpoly(4, w, z, x); // x = t^2 - s * u + p1[0] * r2^2 * q1
	mulpoly(1, r1, r1, u);
	mulpoly(2, u, q2, v);
	ctpoly(4, p2[0], v, z); // z = p2[0] * r1^2 * q2
	addpoly(4, x, z, w); // w = t^2 - s * u + p1[0] * r2^2 * q1 + p2[0] * r1^2 * q2
	m = fdallsol(4, w, y);

	q1[0] = p1[0]; q1[1] = p1[3]; q1[2] = p1[5]; // q1 = p1[0]x^2 + p1[3]x + p1[5]
	q2[0] = p2[0]; q2[1] = p2[3]; q2[2] = p2[5];
	r1[0] = p1[1]; r1[1] = p1[4]; // r1 = p1[1]x + p1[4]
	r2[0] = p2[1]; r2[1] = p2[4];
	ctpoly(2, p2[2], q1, t1);
	ctpoly(2, p1[2], q2, t2);
	subpoly(2, t1, t2, t);
	mulpoly(2, t, t, z);
	addpoly(2, t1, t2, u);
	mulpoly(1, r1, r2, s);
	mulpoly(2, s, u, v);
	subpoly(4, z, v, w);
	mulpoly(1, r2, r2, u);
	mulpoly(2, u, q1, v);
	ctpoly(4, p1[2], v, z);
	addpoly(4, w, z, x);
	mulpoly(1, r1, r1, u);
	mulpoly(2, u, q2, v);
	ctpoly(4, p2[2], v, z);
	addpoly(4, x, z, w);
	n = fdallsol(4, w, x);
	for(l = i = 0; i < n; i++) {
		for(j = 0; j < m; j++) {
			double vl = vofq(p1, x[i], y[j]);
			if((vl < 0.00001) && (vl > -0.00001)) {
				pt[l].x = x[i];
				pt[l].y = y[j];
				l++;
			}
		}
	}
	return l;
}

int isql(double p1[], double p2[], POINT pt[])
{
	int i, j, l, m, n;
	double q1[3], q2[2], r1[2], s[3], t[3], t1[3], t2[3], u[3], v[3], w[3], x[3], y[3];

	q1[0] = p1[2]; q1[1] = p1[4]; q1[2] = p1[5]; // q1 = p1[2]y2 + p1[4]y + p1[5]
	q2[0] = p2[1]; q2[1] = p2[2]; // q2 = p2[1]y + p2[2]
	r1[0] = p1[1]; r1[1] = p1[3]; //r1 = p1[1]y + p1[3]
	ctpoly(2, p2[0] * p2[0], q1, t1);
	mulpoly(1, q2, r1, s);
	ctpoly(2, p2[0], s, t2);
	subpoly(2, t1, t2, t);
	mulpoly(1, q2, q2, u);
	ctpoly(2, p1[0], u, v);
	addpoly(2, t, v, w);
	/*
	w[0] = p2[0] * (p2[0] * p1[2] - p1[1] * p2[1]) + p1[0] * p2[1] * p2[1];
	w[1] = p2[0] * (p2[0] * p1[4] - p1[1] * p2[2] + p1[3] * p2[1]) * 2. * p1[0] * p2[1] * p2[2];
	w[2] = p2[0] * (p2[0] * p1[5] - p1[3] * p2[2]) + p1[0] * p2[2] * p2[2];
	*/
	m = fdallsol(2, w, y);
	printf("color 3 0 0\n");
	//for(i = 0; i < m; i++) printf("line 0. -1. %f\n", y[i]);

	q1[0] = p1[0]; q1[1] = p1[3]; q1[2] = p1[5]; 
	q2[0] = p2[0]; q2[1] = p2[2];
	r1[0] = p1[1]; r1[1] = p1[4];
	ctpoly(2, p2[1] * p2[1], q1, t1);
	mulpoly(1, q2, r1, s);
	ctpoly(2, p2[1], s, t2);
	subpoly(2, t1, t2, t);
	mulpoly(1, q2, q2, u);
	ctpoly(2, p1[2], u, v);
	addpoly(2, t, v, w);
	n = fdallsol(2, w, x);
	printf("color 3 0 0\n");
	//for(i = 0; i < n; i++) printf("line -1. 0. %f\n", x[i]);

	for(l = i = 0; i < n; i++) {
		for(j = 0; j < m; j++) {
			double vl = p2[0] * x[i] + p2[1] * y[j] + p2[2];
			if((vl < 0.00001) && (vl > -0.00001)) {
				pt[l].x = x[i];
				pt[l].y = y[j];
				l++;
			}
		}
	}
	return l;
}

LINE tgl(double a[], POINT p)
{
	LINE l;

	l.a = 2. * a[0] * p.x + a[1] * p.y + a[3];
	l.b = a[1] * p.x + 2. * a[2] * p.y + a[4];
	l.c = -l.a * p.x - l.b * p.y;
	return l;
}

void dcq(double e[], double d[])
{
	d[0] = 4. * e[2] * e[5] - e[4] * e[4];
	d[1] = 2. * e[3] * e[4] - 4. * e[1] * e[5];
	d[2] = 4. * e[0] * e[5] - e[3] * e[3];
	d[3] = -2. * e[1] * e[4] + 4. * e[2] * e[3];
	d[4] = -2. * e[1] * e[3] + 4. * e[0] * e[4];
	d[5] = 4. * e[0] * e[2] - e[1] * e[1];
}

int main(int argc, char *argv[])
{
	int i, n;
	double p1[6], p2[6], dcp1[6], dcp2[6], q1[6], q2[6], q3[6], r[3], r2[6], r3[6], rt;
	POINT pt[4], ct, O;
	LINE l[4], m[4], ln[4];

	if(argc > 6) {
		for(i = 0; i < 6; i++) p1[i] = atof(argv[i + 1]);
	}
	else {
		p1[0] = 1.5; p1[1] = 1.; p1[2] = 1.; p1[3] = 0.2; p1[4] = 0.1; p1[5] = -1.5;
	}
	if(argc > 12) {
		for(i = 0; i < 6; i++) p2[i] = atof(argv[i + 7]);
	}
	else {
		p2[0] = 1.; p2[1] = -1.5; p2[2] = 1.; p2[3] = -0.1; p2[4] = 0.3; p2[5] = -1.;
	}
	drawq(p1);
	drawq(p2);
	n = is2q(p1, p2, pt);
	printf("color 0 0 3\n");
	for(i = 0; i < n;i++) WRITE(l[i] = tgl(p1, pt[i]));
	printf("color 0 2 0\n");
	for(i = 0; i < n;i++) WRITE(m[i] = tgl(p2, pt[i]));
	printf("color 3 0 0\n");
	if(n == 4) {
		double srt1, srt2;
		//WRITE((l[0] * l[1]) * (l[2] * l[3]));
		//WRITE((l[0] * l[2]) * (l[1] * l[3]));
		WRITE((l[0] * l[3]) * (l[2] * l[1]));
		ln[0] = pt[0] * pt[3]; ln[1] = pt[2] * pt[1];
		ct = ln[0] * ln[1];
		ctpoly(5, vofq(p2, ct.x, ct.y), p1, q1);
		ctpoly(5, vofq(p1, ct.x, ct.y), p2, q2);
		rt = (q1[5] - q2[5]) / (ln[0].c * ln[1].c);
		//fprintf(stderr, "q15 = %f, q25 = %f, rt = %f\n", q1[5], q2[5], rt);
		if(rt > 0.) srt1 = sqrt(rt);
		else srt1 = sqrt(-rt);
		srt1 *= 0.85;
		srt2 = rt / srt1;
		ln[2].a = srt1 * ln[0].a - srt2 * ln[1].a;
		ln[2].b = srt1 * ln[0].b - srt2 * ln[1].b;
		ln[2].c = srt1 * ln[0].c - srt2 * ln[1].c;
		printf("gray 0.5\n");
		for(i = 0; i < 3; i++) WRITE(ln[i]);
		r[0] = ln[2].a; r[1] = ln[2].b; r[2] = ln[2].c;
		r2[0] = r[0] * r[0]; r2[1] = 2. * r[0] * r[1]; r2[2] = r[1] * r[1]; r2[3] = 2. * r[0] * r[2]; r2[4]= 2. * r[1] * r[2]; r2[5] = r[2] * r[2];
		ctpoly(5, 0.25, r2, r3);
		addpoly(5, q1, r3, q3);
		drawq(q3);
		n = isql(p1, r, pt);
		//n = is2q(p1, q3, pt);
		printf("color 0 0 3\n");
		for(i = 0; i < n; i++) WRITE(tgl(p1, pt[i]));
		ln[2].a = srt1 * ln[0].a + srt2 * ln[1].a;
		ln[2].b = srt1 * ln[0].b + srt2 * ln[1].b;
		ln[2].c = srt1 * ln[0].c + srt2 * ln[1].c;
		printf("gray 0.5/n");
		WRITE(ln[2]);
		r[0] = ln[2].a; r[1] = ln[2].b; r[2] = ln[2].c;
		n = isql(p2, r, pt);
		//n = is2q(p2, q3, pt);
		printf("color 0 3 0\n");
		for(i = 0; i < n; i++) WRITE(tgl(p2, pt[i]));
	}
	return 0;
}
