#include "planegeometry.h"
#include <math.h>
#include "uq.h"

int main(int argc, char *argv[])
{
	int i, j, n;
	double p1[6], p2[6], dcp1[6], dcp2[6], h[3];
	POINT pt[4], qt[5], tpt1[4], tpt2[4];
	LINE l[4], m[4];

	if(argc > 6) {
		for(i = 0; i < 6; i++) p1[i] = atof(argv[i + 1]);
	}
	else {
		p1[0] = 1.; p1[1] = 0.3; p1[2] = -1.; p1[3] = 0.; p1[4] = 0.; p1[5] = -1.;
	}
	if(argc > 12) {
		for(i = 0; i < 6; i++) p2[i] = atof(argv[i + 7]);
	}
	else {
		p2[0] = 4.; p2[1] = 0.; p2[2] = -1.; p2[3] = 0.5; p2[4] = 0.6; p2[5] = -8.;
	}
	drawq(p1);
	drawq(p2);
	n = is2q(p1, p2, pt);
	printf("gray 0.6\n");
	for(i = 0; i < n-1; i++) {
		for(j = i+1; j < n; j++) WRITE(pt[i] * pt[j]);
	}
	printf("color 0 0 3\n");
	dcq(p1, dcp1);
	dcq(p2, dcp2);
	n = is2q(dcp1, dcp2, pt);
	for(i = 0; i < n; i++) {
		l[i].a = pt[i].x;
		l[i].b = pt[i].y;
		l[i].c = -1.;
		WRITE(l[i]);
	}
	printf("color 3 0 0\n");
	if(n == 4) {
		WRITE((l[0] * l[1]) * (l[2] * l[3]));
		WRITE((l[0] * l[2]) * (l[1] * l[3]));
		WRITE((l[0] * l[3]) * (l[1] * l[2]));
	}
	return 0;
}
