#include "planegeometry.h"
#include <math.h>
#include "uq.h"

void lxl(LINE l, LINE m, double a[])
{
	a[0] = l.a * m.a;
	a[1] = l.a * m.b + l.b * m.a;
	a[2] = l.b * m.b;
	a[3] = l.a * m.c + l.c * m.a;
	a[4] = l.b * m.c + l.c * m.b;
	a[5] = l.c * m.c;
	return;
}

void lxq(LINE l, double a[], double b[])
{
	b[0] = a[0] * l.a;
	b[1] = a[0] * l.b + a[1] * l.a;
	b[2] = a[1] * l.b + a[2] * l.a;
	b[3] = a[2] * l.b;
	b[4] = a[0] * l.c + a[3] * l.a;
	b[5] = a[1] * l.c + a[3] * l.b + a[4] * l.a;
	b[6] = a[2] * l.c + a[4] * l.b;
	b[7] = a[3] * l.c + a[5] * l.a;
	b[8] = a[4] * l.c + a[5] * l.b;
	b[9] = a[5] * l.c;
	return;
}
	
int main(int argc, char *argv[])
{
	LINE l[3], m[3], n[3];
	int i;
	double a[10], b[10], c, d, e, p[6];

	l[0].a = 1.; l[0].b = -0.8; l[0].c = 1.;
    l[1].a = 1.; l[1].b = 2.; l[1].c = 0.;
	l[2].a = 1.; l[2].b = -0.9; l[2].c = -1.5;
	m[0].a = 1.; m[0].b = 0.7; m[0].c = 1.;
	m[1].a = 1.; m[1].b = -1.9; m[1].c = 0.;
	m[2].a = 1.; m[2].b = 0.9; m[2].c = -1.5;
	n[0].a = 1.; n[0].b = 0.; n[0].c = 1.;
	n[1].a = 1.; n[1].b = 0.2; n[1].c = 0.;
	n[2].a = 1.; n[2].b = 0.1; n[2].c = -1.5;
	printf("line 0 1. 0.\ncolor 0 0 3\n");
	for(i = 0; i < 3; i++) WRITE(l[i]);
	printf("color 0 3 0\n");
	for(i = 0; i < 3; i++) WRITE(m[i]);
	printf("color 3 0 0\n");
	for(i = 0; i < 3; i++) WRITE(n[i]);
	for(i = 0, c = d = e = 0.; i < 3; i++) {
		c += l[i].a + l[i].c;
		d += m[i].a + m[i].c;
		e += n[i].a + n[i].c;
	}
	lxl(l[0], l[1], p);
	lxq(l[2], p, a);
	lxl(m[0], m[1], p);
	lxq(m[2], p, b);
	for(i = 0; i < 10; i++) {
		a[i] *= d;
		a[i] -= c * b[i];
	}
	//fprintf(stderr, "c3 = %f, x2 = %f, x = %f, c = %f\n", a[0], a[4], a[7], a[9]);
	printf("color 0 2 2\n");
	p[0] = a[1]; p[1] = a[2]; p[2] = a[3]; p[3] = a[5]; p[4] = a[6]; p[5] = a[8];
	drawq(p);
	lxl(l[0], l[1], p);
	lxq(l[2], p, a);
	lxl(n[0], n[1], p);
	lxq(n[2], p, b);
	for(i = 0; i < 10; i++) {
		a[i] *= d;
		a[i] -= c * b[i];
	}
	printf("color 2 0 2\n");
	p[0] = a[1]; p[1] = a[2]; p[2] = a[3]; p[3] = a[5]; p[4] = a[6]; p[5] = a[8];
	drawq(p);
	lxl(m[0], m[1], p);
	lxq(m[2], p, a);
	lxl(n[0], n[1], p);
	lxq(n[2], p, b);
	for(i = 0; i < 10; i++) {
		a[i] *= d;
		a[i] -= c * b[i];
	}
	printf("color 2 2 0\n");
	p[0] = a[1]; p[1] = a[2]; p[2] = a[3]; p[3] = a[5]; p[4] = a[6]; p[5] = a[8];
	drawq(p);
	return 0;
}
