#include "planegeometry.h"
#include <math.h>

double inpr(POINT A, POINT B)
{
	return A.x * B.x + A.y * B.y;
}

void agoftrl(POINT A, POINT B, POINT C)
{
	POINT D, E;

	D.x = B.x - A.x;
	D.y = B.y - A.y;
	E.x = C.x - A.x;
	E.y = C.y - A.y;
	fprintf(stderr, "%f ", acos(inpr(D, E) / sqrt(inpr(D, D) * inpr(E, E))));
	D.x = A.x - B.x;
	D.y = A.y - B.y;
	E.x = C.x - B.x;
	E.y = C.y - B.y;
	fprintf(stderr, "%f ", acos(inpr(D, E) / sqrt(inpr(D, D) * inpr(E, E))));
	D.x = A.x - C.x;
	D.y = A.y - C.y;
	E.x = B.x - C.x;
	E.y = B.y - C.y;
	fprintf(stderr, "%f ", acos(inpr(D, E) / sqrt(inpr(D, D) * inpr(E, E))));
	fprintf(stderr, "\n");
}

POINT dvpt(POINT A, POINT B, int m, int n)
{
	POINT P;

	P.x = (n * A.x + m * B.x) / (m + n);
	P.y = (n * A.y + m * B.y) / (m + n);
	return P;
}

int main(int argc, char *argv[])
{
	POINT A, B, C, D, E, F, D2, E2, F2, P, Q, O;
	LINE l, m, n, l2, m2, n2;

	READ(&A);
	READ(&B);
	READ(&C);
	//agoftrl(A, B, C);
	WRITE(A, B, C);
	printf("color 0 0 3\n");
	if(argc > 2) P = dvpt(B, C, atoi(argv[1]), atoi(argv[2]));
	else P = dvpt(B, C, 2, 1);
	if(argc > 4) Q = dvpt(C, A, atoi(argv[3]), atoi(argv[4]));
	else Q = dvpt(C, A, 3, 1);
	WRITE(l = A * P);
	WRITE(m = B * Q);
	O = l * m;
	WRITE(n = C * O);
	printf("color 0 3 0\n");
	WRITE(l2 = (B % C) / l);
	WRITE(m2 = (C % A) / m);
	WRITE(n2 = (A % B) / n);
	D = l * m2;
	E = m * n2;
	F = n * l2;
	agoftrl(D, E, F);
	printf("color 3 0 0\n");
	WRITE(D, E, F);
	D2 = l2 * m;
	E2 = m2 * n;
	F2 = n2 * l;
	agoftrl(D2, E2, F2);
	WRITE(D2, E2, F2);
	printf("color 3 2 0\n");
	WRITE(D, D2);
	WRITE(E, E2);
	WRITE(F, F2);
	return 0;
}
