#include "planegeometry.h"
#include <math.h>

POINT dvpt(POINT A, POINT B, int m, int n)
{
	POINT P;

	P.x = (n * A.x + m * B.x) / (m + n);
	P.y = (n * A.y + m * B.y) / (m + n);
	return P;
}

double area(POINT A, POINT B, POINT C)
{
	LINE l;
	POINT H;

	l = B * C;
	return 0.5 * (B + C) * (A + l);
}

int main(int argc, char *argv[])
{
	POINT A, B, C, D, E, F, D2, E2, F2, P, Q, R;
	LINE l, m, n, l2, m2, n2;
	int i;
	double d;

	READ(&A);
	READ(&B);
	READ(&C);
	WRITE(A, B, C);
	printf("color 0 0 3\n");
	if(argc > 2) P = dvpt(B, C, atoi(argv[1]), atoi(argv[2]));
	else P = dvpt(B, C, 2, 1);
	if(argc > 4) Q = dvpt(C, A, atoi(argv[3]), atoi(argv[4]));
	else Q = dvpt(C, A, 3, 1);
	if(argc > 4) Q = dvpt(A, B, atoi(argv[5]), atoi(argv[6]));
	else R = dvpt(A, B, 3, 2);
	WRITE(l = A * P);
	WRITE(m = B * Q);
	WRITE(n = C * R);
	d = area(l * m, m * n, n * l);
	fprintf(stderr, "s(lmn) = %f (%f)\n", d, sqrt(d));
	printf("color 0 3 0\n");
	WRITE(l2 = (B % C) / l);
	WRITE(m2 = (C % A) / m);
	WRITE(n2 = (A % B) / n);
	D = l * m2;
	E = m * n2;
	F = n * l2;
	fprintf(stderr, "s(DEF) = %f ", area(D, E, F));
	printf("color 3 0 0\n");
	WRITE(D, E, F);
	D2 = l2 * m;
	E2 = m2 * n;
	F2 = n2 * l;
	d = area(D2, E2, F2);
	fprintf(stderr, "s(D2E2F2) = %f (%f)\n", d, sqrt(d));
	WRITE(D2, E2, F2);
	for(i = 0; i < 3; i++) {
		l2.c = 0.5 * (l.c + l2.c);
		m2.c = 0.5 * (m.c + m2.c);
		n2.c = 0.5 * (n.c + n2.c);
		D = l * m2;
		E = m * n2;
		F = n * l2;
		fprintf(stderr, "s(DEF) = %f ", area(D, E, F));
		D2 = l2 * m;
		E2 = m2 * n;
		F2 = n2 * l;
		d = area(D2, E2, F2);
		fprintf(stderr, "s(D2E2F2) = %f (%f)\n", d, sqrt(d));
	}
	return 0;
}
