#include "planegeometry.h"
#include <math.h>

double inpr(POINT A, POINT B)
{
	return A.x * B.x + A.y * B.y;
}

void agoftrl(POINT A, POINT B, POINT C)
{
	POINT D, E;

	D.x = B.x - A.x;
	D.y = B.y - A.y;
	E.x = C.x - A.x;
	E.y = C.y - A.y;
	fprintf(stderr, "%f ", acos(inpr(D, E) / sqrt(inpr(D, D) * inpr(E, E))));
	D.x = A.x - B.x;
	D.y = A.y - B.y;
	E.x = C.x - B.x;
	E.y = C.y - B.y;
	fprintf(stderr, "%f ", acos(inpr(D, E) / sqrt(inpr(D, D) * inpr(E, E))));
	D.x = A.x - C.x;
	D.y = A.y - C.y;
	E.x = B.x - C.x;
	E.y = B.y - C.y;
	fprintf(stderr, "%f ", acos(inpr(D, E) / sqrt(inpr(D, D) * inpr(E, E))));
	fprintf(stderr, "\n");
}

int main(int argc, char *argv[])
{
	POINT A, B, C, D, E, F, D2, E2, F2;
	LINE l, m, n, l2, m2, n2;

	READ(&A);
	READ(&B);
	READ(&C);
	agoftrl(A, B, C);
	WRITE(A, B, C);
	printf("color 0 0 3\n");
	WRITE(l = A | (B * C));
	WRITE(m = B | (C * A));
	WRITE(n = C | (A * B));
	printf("color 0 3 0\n");
	WRITE(l2 = A | B);
	WRITE(m2 = B | C);
	WRITE(n2 = C | A);
	D = l * l2;
	E = m * m2;
	F = n * n2;
	agoftrl(D, E, F);
	printf("color 3 0 0\n");
	WRITE(D, E, F);
	l2 = A | C;
	m2 = B | A;
	n2 = B | C;
	D2 = l * l2;
	E2 = m * m2;
	F2 = n * n2;
	WRITE(D2, E2, F2);
	printf("color 3 2 0\n");
	WRITE(D, F2);
	WRITE(E, D2);
	WRITE(F, E2);
	return 0;
}
