#include <stdio.h>
#include "planegeometry.h"
#include <math.h>

double f(double t)
{
	return 2. * cos(t) + cos(2.* t);
}

double g(double t)
{
	return 2. * sin(t) - sin(2.* t);
}

int main(int argc, char *argv[])
{
    POINT a[3], b[3], P, P0;
    LINE l, m[3], n[3];
    int i, adp = 1;
	double t, dt = 0.01, st, s3t;

	if(argc > 1) {
		t = atof(argv[1]);
		st = sin(0.5 * t);
		s3t = sin(1.5 * t);
		a[0].x = s3t / st;
		a[1].y = (s3t + st) / cos(0.5 * t);
	}
	else {
		t = 0.5 * M_PI;
		a[0].x = 1.;
		a[1].y = 2.;
	}
	a[0].y = 0.;
	a[1].x = a[2].x = -1.;
	a[2].y = -a[1].y;
	l.a = 1.; l.b = 0.; l.c = 0.;
	WRITE(a[0], a[1], a[2]);
	for(i = 0; i < 3; i++) m[i] = a[(i + 1) % 3] * a[(i + 2) % 3];
	P.x = 2. * cos(t) + cos(2. * t); P.y = 2. * sin(t) - sin(2. * t);
	fprintf(stderr, "%f = %f\n", a[0] + ((a[2] | m[2]) * m[2]), a[1] + P);
	printf("color 3 0 0\n");
	P0.x = 3.; P0.y = 0.;
	for(t = dt; t < 2. * M_PI; t += dt) {
		P.x = f(t); P.y = g(t);
		WRITE(P0, P);
		P0 = P;
	}
	printf("pause\n");
	for(t = dt; t < M_PI; t += dt) {
		printf("copy 0 %d\nactive %d\n", adp, adp);
		printf("color 0 0 3\n");
		l.a = cos(t); l.b = sin(t);
		WRITE(l);
		printf("color 0 3 3\n");
		for(i = 0; i < 3; i++) {
			//m[i] = a[(i + 1) % 3] * a[(i + 2) % 3];
			WRITE(b[i] = (a[i] | l) * l, a[i]);
		}
		printf("color 3 0 3\n");
		for(i = 0; i < 3; i++) WRITE(n[i] = b[i] | m[i]);
		printf("color 3 0 0\n");
		WRITE((n[0] * n[1]) | l);
		printf("display %d\ntsleep 10\n", adp);
		if(adp == 1) adp = 2;
		else adp = 1;
	}
	return 0;
}
