#include <stdio.h>
#include "planegeometry.h"
#include <math.h>

POINT a[3];
LINE m[3];

LINE isp(LINE l)
{
	int i;
    LINE n[3];

	for(i = 0; i < 3; i++) n[i] = ((a[i] | l) * l) | m[i];
	return (n[0] * n[1]) | l;
}

int main()
{
    POINT b[3], P, P0, MP[3];
    LINE l, n, n0;
	CIRC C;
    int i;
	double t, dt = 0.01;
    
    for(i = 0; i < 3; i++) READ(a + i);
	for(i = 0; i < 3; i++) m[i] = a[(i + 1) % 3] * a[(i + 2) % 3];
	for(i = 0; i < 3; i++) MP[i] = a[(i + 1) % 3] % a[(i + 2) % 3];
	C.c = (MP[0] | MP[1]) * (MP[0] | MP[2]);
	C.r = C.c + MP[0];
	printf("gray 0.\n");
	WRITE(a[0], a[1], a[2]);
	printf("gray 0.7\n");
	WRITE(C);
	printf("color 0 0 3\n");
	for(i = 0; i < 3; i++) {
		WRITE((l = a[i] | m[i]) * m[i], a[i]);
		P0 = l * m[i];
		P.x = a[(i + 1) % 3].x - P0.x + a[(i + 2) % 3].x;
		P.y = a[(i + 1) % 3].y - P0.y + a[(i + 2) % 3].y;
		WRITE(a[i], P);
	}
	printf("color 3 0 0\n");
	l.a = 1.; l.b = 0.; l.c = 0.;
	n0 = isp(l);
	l.a = cos(dt); l.b = sin(dt); l.c = 0.;
	P0 = (n = isp(l)) * n0;
	n0 = n;
	for(t = 2 * dt; t < M_PI; t += dt) {
		l.a = cos(t); l.b = sin(t);
		P = (n = isp(l)) * n0;
		WRITE(P0, P);
		n0 = n;
		P0 = P;
	}
	return 0;
}
