#include <stdio.h>
#include "planegeometry.h"
#include <math.h>

POINT a[3];
LINE m[3];

POINT isp(LINE l)
{
	int i;
    LINE n[3];

	for(i = 0; i < 3; i++) n[i] = ((a[i] | l) * l) | m[i];
	return n[0] * n[1];
}

int main(int argc, char *argv[])
{
    POINT b[3], P, P0, Ct;
    LINE l, n[3];
    int i;
	CIRC c;
	double t, dt = 0.01;

	if(argc > 1) Ct.x = atof(argv[1]);
	else Ct.x = 0.;
	if(argc > 2) Ct.y = atof(argv[2]);
	else Ct.y = 0.;
    for(i = 0; i < 3; i++) READ(a + i);
	for(i = 0; i < 3; i++) m[i] = a[(i + 1) % 3] * a[(i + 2) % 3];
	printf("gray 0.\n");
	WRITE(a[0], a[1], a[2]);
	l.a = 1.; l.b = 0.; l.c = -Ct.x;
	printf("color 0 0 3\n");
	c.c = (a[0] | a[1]) * (a[1] | a[2]);
	c.r = c.c + a[0];
	WRITE(c);
	//WRITE(l);
	/*
	printf("color 0 3 0\n");
	for(i = 0; i < 3; i++) WRITE(n[i] = a[i] | m[i]);
	P0 = n[0] * n[1];
	for(i = 0; i < 3; i++) WRITE(a[i] % P0);
	*/
	printf("color 3 0 0\n");
	P0 = isp(l);
	for(t = dt; t < M_PI; t += dt) {
		l.a = cos(t); l.b = sin(t); l.c = -l.a * Ct.x - l.b * Ct.y;
		P = isp(l);
		WRITE(P0, P);
		P0 = P;
	}
	return 0;
}
