#include <stdio.h>
#include "planegeometry.h"
#include <math.h>

POINT A[3];
LINE m[3];

POINT isp(LINE l)
{
	int i;
    LINE n[3];

	for(i = 0; i < 3; i++) n[i] = ((A[i] | l) * l) | m[i];
	return n[0] * n[1];
}

int main(int argc, char *argv[])
{
    POINT MP[3], P, P0, G;
    LINE l, n[3], k, k0;
	CIRC c;
    int i;
	double t, dt = 0.01;

	for(i = 0; i < 3; i++) READ(A + i);
	for(i = 0; i < 3; i++) m[i] = A[(i + 1) % 3] * A[(i + 2) % 3];
	WRITE(A[0], A[1], A[2]);
	printf("gray 0.7\n");
	for(i = 0; i < 3; i++) MP[i] = A[i] % A[(i + 1) % 3];
	c.c = (MP[0] | MP[1]) * (MP[1] | MP[2]);
	c.r = c.c + MP[0];
	WRITE(c);
	printf("color 0 0 3\n");
	G = (A[0] | A[1]) * (A[1] | A[2]);
	l.a = 1.; l.b = 0.; l.c = -G.x;
	P0 = isp(l);
	k0.a = 0.; k0.b = -1.; k0.c = P0.y;
	for(t = dt; t < 3.14; t += dt) {
		l.a = cos(t); l.b = sin(t); l.c = -l.a * G.x - l.b * G.y;
		P = isp(l);
		k.a = l.b; k.b = -l.a; k.c = -k.a * P.x - k.b * P.y;
		P = k0 * k;
		WRITE(P0, P);
		k0 = k;
		P0 = P;
	}
	return 0;
}
