#include "planegeometry.h"
#include <math.h>

int fdt(POINT G, double tt[], double d[])
{
	double a, b, c, t, x, y;
	int n = 0, f;
	if(G.y > 0.) f = 1;
	else f = -1;
	for(t = 0; t < M_PI; t += 0.001) {
		a = sin(t);
		b = cos(t);
		c = sin(3 * t);
		if((a * G.x + b * G.y - c) * f < 0.) {
			tt[n] = t;
			x = cos(2 * t) + 2. * cos(t) - G.x;
			y = sin(2 * t) - 2. * sin(t) - G.y;
			d[n++] = sqrt(x * x + y * y);
			f *= -1;
		}
	}
	return n;
}
	
int main(int argc, char *argv[])
{
	POINT v[3], G, G0, G2, N, H, O, F[3], A, B;
	LINE k[3], l;
	double t[3], d[3], s, sm, sh;
	int i, j, m;

	printf("circle 0 0 2\n");
	/*
	v[0].x = 2.; v[0].y = 0.;
	v[1].x = -1.; v[1].y = sqrt(3.);
	v[2].x = -1.; v[2].y = -v[1].y;
	*/
	t[0] = 0.; t[1] = 2.; t[2] = 4.5;
	for(i = 0; i < 3; i++) {
		v[i].x = 2. * cos(t[i]);
		v[i].y = 2. * sin(t[i]);
	}
	if(argc > 1) G.x = atof(argv[1]);
	else G.x = 1.1;
	if(argc > 2) G.y = atof(argv[2]);
	else G.y = 0.3;
	//WRITE(G);
	//G.y *= -1.;
	for(i = 0; i < 3; i++) {
		WRITE(k[i] = v[(i + 1) % 3] * v[(i + 2) % 3]);
	}
	H = (v[0] | k[0]) * (v[1] | k[1]);
	O = (v[0] | v[1]) * (v[1] | v[2]);
	N = O % H;
	A = v[0] % v[1];
	sm = atan2(A.y - N.y, A.x - N.x);
	A = (v[2] | k[2]) * k[2];
	sh = atan2(A.y - N.y, A.x - N.x);
	s = (2. * sm + sh - M_PI) / 3.;
	//fprintf(stderr, "s = %f\n", s);
	G0.x = G.x - N.x;
	G0.y = G.y - N.y;
	G2.x = G0.x * cos(-s) - G0.y * sin(-s);
	G2.y = G0.y * cos(-s) + G0.x * sin(-s);
	printf("color 0 0 3\n");
	m = fdt(G2, t, d);
	for(i = 0; i < m; i++) {
		if(i == 1) printf("color 0 3 0\n");
		else if(i == 2) printf("color 3 0 0\n");
		l.a = cos(t[i] + s);
		l.b = sin(t[i] + s);
		l.c = d[i] - 2.;
		WRITE(l);
		for(j = 0; j < 3; j++) {
			F[j] = (v[j] | l) * l;
			WRITE(v[j], F[j]);
			WRITE(F[j] | k[j]);
		}
	}
	return 0;
}
