#include "planegeometry.h"

POINT harmocon(POINT A, POINT B, POINT C)
{
	POINT D, E, F, O;

	O.x = 10.9; O.y = 5.3;
	E = O % A;
	F = (A * ((B * E) * (O * C))) * (O * B);
	return (A * B) * (E * F);
	/*
	POINT D;
	double c, x, y;

	x = B.x - A.x; y = B.y - A.y;
	if((x * x) > (y * y)) {
		x = B.x - A.x; y = C.x - A.x;
		c = y / (2. * y - x);
		D.x = A.x + x * c;
		D.y = A.y + (B.y - A.y) * c;
	}
	else {
		x = B.y - A.y; y = C.y - A.y;
		c = y / (2. * y - x);
		D.y = A.y + x * c;
		D.x = A.x + (B.x - A.x) * c;
	}
	return D;
	*/
}

double crsrt(POINT A, POINT B, POINT C, POINT D)
{
	double x, y;
	x = B.x - A.x; y = B.y - A.y;
	if((x * x) > (y * y)) return (C.x - A.x) * (D.x - B.x) /((D.x - A.x) * (C.x - B.x));
	else return (C.y - A.y) * (D.y - B.y) /((D.y - A.y) * (C.y - B.y));
}

int main()
{
	POINT A, B, C, D, E, F, O, P, Q;
	LINE l;

	A.x = 2.; A.y = 2.; B.x = -1.; B.y = -1.4;
	D.x = -3.; D.y = 3.5; E.x = 1.; E.y = -1.;
	O = (A * B) * (D * E);
	C = harmocon(A, B, O);
	//fprintf(stderr, "%f\n", crsrt(A, B, O, C));
	F = harmocon(D, E, O);
	//fprintf(stderr, "%f\n", crsrt(D, E, O, F));
	P = (A * D) * (l = C * F);
	Q = (A * E) * l;
	WRITE(A, C); WRITE(D, F);
	WRITE(D, P); WRITE(C, P); WRITE(B, P);
	WRITE(D, Q); WRITE(A, Q);
	//fprintf(stderr, "%f\n", crsrt(P, Q, C, F));
	return 0;
}
