#include "planegeometry.h"
#include <math.h>
#include "uq.h"

double a = 1., b = 1., c = 0.1, d = 1.1;

double crsrtpts(POINT A, POINT B, POINT C, POINT D)
{
	double x, y;
	x = B.x - A.x; y = B.y - A.y;
	if((x * x) > (y * y)) return (C.x - A.x) * (D.x - B.x) /((D.x - A.x) * (C.x - B.x));
	else return (C.y - A.y) * (D.y - B.y) /((D.y - A.y) * (C.y - B.y));
}

double crsrtlns(LINE a, LINE b, LINE c, LINE d)
{
	LINE l;

	l.a = 1.; l.b = 0.14; l.c = 10.;
	return crsrtpts(l * a, l * b, l * c, l * d);
}

POINT ptonel(double t)
{
	POINT P;

	P.x = a * cos(t) + b * sin(t);
	P.y = c * cos(t) + d * sin(t);
	return P;
}

int main(int argc, char *argv[])
{
	POINT A[4], P;
	LINE l[4];
	int i, j;
	double t, e[6];

	A[0] = ptonel(0.); A[2] = ptonel(0.7 * M_PI); A[1] = ptonel(M_PI); A[3] = ptonel(1.3 * M_PI);
	e[0] = c * c + d * d; e[1] = -2 * (a * c + b * d); e[2] = a * a + b * b; e[3] = e[4] = 0.;
	t = a * d - b * c; e[5] = -t * t;
	drawq(e);
	printf("color 0 0 3\n");
	P = ptonel(1.);
	for(i = 0; i < 4; i++) WRITE(l[i] = P * A[i]);
	fprintf(stderr, "%f\n", crsrtlns(l[0], l[1], l[2], l[3]));
	for(i = 1; i < argc; i++) {
		P = ptonel(atof(argv[i]));
		for(j = 0; j < 4; j++) l[j] = P * A[j];
		fprintf(stderr, "%f\n", crsrtlns(l[0], l[1], l[2], l[3]));
	}
	return 0;
}

