#include "planegeometry.h"
#include <math.h>

double f(double t)
{
	return t + cos(1.5 * M_PI - t);
}

double g(double t)
{
	return 1 + sin(1.5 * M_PI - t);
}

double f1(double t)
{
	return 1 + sin(1.5 * M_PI - t);
}

double g1(double t)
{
	return -cos(1.5 * M_PI - t);
}

double f2(double t)
{
	return -cos(1.5 * M_PI - t);
}

double g2(double t)
{
	return -sin(1.5 * M_PI - t);
}

int main()
{
	int ad;
	POINT P, P0, Q;
	LINE l;
    double t, dt = .01, x1, y1, x2, y2, ml, r;

	P0.x = P0.y = 0.;
	printf("line 0 1 0\ncopy 0 1\nactive 1\ncircle 0 1. 1.\ncolor 0 0 3\ndisk 0. 0. 0.03\ndisplay 1\npause\n");
	for(t = dt, ad =2; t < 2 * M_PI; t += dt) {
		P.x = f(t); P.y = g(t);
		printf("active 0\ncolor 0 0 3\n");
		WRITE(P0, P);
		printf("copy 0 %d\nactive %d\ndisk %f %f 0.03\ngray 0\ncircle %f 1. 1.\ndisplay %d\ntsleep 3\n", ad, P.x, P.y, ad, t, ad);
		if(ad == 1) ad = 2;
		else ad = 1;
		P0 = P;
	}
	printf("pause\n");
	for(P0.x = P0.y = 0., t = dt; t < 2 * M_PI; t += dt) {
		x1 = f1(t); y1 = g1(t); x2 = f2(t); y2 = g2(t);
		ml = (r = x1 * x1 + y1 * y1) / (y2 * x1 - x2 * y1);
		Q.x = f(t); Q.y = g(t);
		P.x = Q.x - ml * y1; P.y = Q.y + ml * x1;
		printf("active 0\ncolor 3 0 0\n", ad);
		WRITE(P0, P);
		printf("copy 0 %d\nactive %d\ncolor 3 2 0\ncircle %f %f %f\n", ad, ad, P.x, P.y, -ml * sqrt(r));
		WRITE(P, Q);
		l.a = y1; l.b = -x1; l.c = -Q.x * y1 + Q.y * x1;
		WRITE(l);
		printf("display %d\ntsleep 3\n", ad);
		if(ad == 1) ad = 2;
		else ad = 1;
		P0 = P;
	}
	return 0;
}
