#include "planegeometry.h"
#include <math.h>

int n = 2;
double R = 1., r;

double f(double t)
{
	return R * cos(t) + r * cos(n * t + M_PI);
}

double g(double t)
{
	return R * sin(t) + r * sin(n * t + M_PI);
}

double f1(double t)
{
	return -R * sin(t) - r * n * sin(n * t + M_PI);
}

double g1(double t)
{
	return R * cos(t) + r * n * cos(n * t + M_PI);
}

double f2(double t)
{
	return -R * cos(t) - r * n * n * cos(n * t + M_PI);
}

double g2(double t)
{
	return -R * sin(t) - r * n * n * sin(n * t + M_PI);
}

int main(int argc, char *argv[])
{
	POINT P, P0, Q;
	double t, dt = 0.01, t0, x1, y1, x2, y2, v, u, ml, c0, s0;

	if(argc > 1) n = atoi(argv[1]);
	r = R / n;
	R += r; n++;
	P0.x = 1.; P0.y = 0.;
	printf("circle 0. 0. 1.\ncolor 0 0 3\n");
	for(t = dt; t < 2 * M_PI; t += dt) {
		P.x = f(t); P.y = g(t);
		WRITE(P0, P);
		P0 = P;
	}
	P0.x = 1.; P0.y = 0.;
	printf("color 3 0 0\n");
	for(t = dt; t < 2 * M_PI; t += dt) {
		x1 = f1(t); y1 = g1(t); x2 = f2(t); y2 = g2(t);
		u = y2 * x1 - x2 * y1;
		v = x1 * x1 + y1 * y1;
		ml = v / u;
		P.x = f(t) - ml * y1; P.y = g(t) + ml * x1;
		WRITE(P0, P);
		P0 = P;
	}
	printf("pause\ncolor 3 2 0\n");
	ml = (R - r) / (R + r);
	t0 = M_PI / (n - 1);
	c0 = cos(t0); s0 = sin(t0);
	x1 = ml * f(0.); y1 = ml * g(0.);
	P0.x = c0 * x1 - s0 * y1; P0.y = s0 * x1 + c0 * y1;
	for(t = dt; t < 2 * M_PI; t += dt) {
		x1 = ml * f(t); y1 = ml * g(t);
		P.x = c0 * x1 - s0 * y1; P.y = s0 * x1 + c0 * y1;
		WRITE(P0, P);
		P0 = P;
	}
	return 0;
}

		
