#include "planegeometry.h"
#include <math.h>

LINE anol(LINE l)
{
	LINE m;
	double a, b;

	a = l.a / (l.b - 2.5);
	b = a * l.b - l.a;
	m.b = 2. * a * b / (a * a + 1.) - l.b;
	m.a = a * (m.b - l.b) + l.a;
	m.c = -1.;
	return m;
}

int main(int argc,  char *argv[])
{
	LINE a, b, c, d, e, f, l, m, n;
	POINT A, B, C, D, E, F, P, Q, R;
	double t;

	if(argc > 1) t = atof(argv[1]);
	else t = -0.025;
	printf("circle 0. 0. 1.\n");
	a.a = cos(t);
	a.b = sin(t);
	a.c = c.c = d.c = -1.;
	b = anol(a);
	c.a = cos(1.63); c.b = sin(1.63);
	f = anol(c);
	d.a = cos(2.23); d.b = sin(2.23);
	e = anol(d);	
	WRITE(a); WRITE(b); WRITE(c); WRITE(d); WRITE(e); WRITE(f);
	l.a = 0.; l.b = 2.5; l.c = -1.;
	m = (a * d) * (b * c);
	n = (c * d) * (b * e);
	A = a * b; B = a * d; C = d * e; D = e * f; E = c * f; F = b * c;
	printf("color 0 0 3\n");
	WRITE(l);
	WRITE(A); WRITE(C); WRITE(E);
	printf("color 0 3 0\n");
	WRITE(m);
	WRITE(B); WRITE(D); WRITE(F);
	printf("color 3 0 0\n");
	WRITE(n);
	WRITE(P = a * f); WRITE(Q = d * c); WRITE(R = e * b);
	printf("color 0 2 2\n");
	WRITE(A * D); WRITE(B * E); WRITE(C * F);
	printf("color 2 0 2\n");
	WRITE(A * Q); WRITE(R * E); WRITE(C * P);
	printf("color 2 2 0\n");
	WRITE(D * Q); WRITE(R * B); WRITE(F * P);
	return 0;
}

	
