#include "planegeometry.h"
#include <math.h>

int m = 1, n = 2;

double f(double t)
{
	return cos(m * t);
}

double g(double t)
{
	return sin(n * t);
}

double f1(double t)
{
	return -m * sin(m * t);
}

double g1(double t)
{
	return n * cos(n * t);
}

double f2(double t)
{
	return -m * m * cos(m * t);
}

double g2(double t)
{
	return -n * n * sin(n * t);
}

int main(int argc, char *argv[])
{
	POINT P, P0, Q;
	double t, dt = 0.01, x1, y1, x2, y2, v, u, u0, ml;

	if(argc > 1) m = atoi(argv[1]);
	if(argc > 2) n = atoi(argv[2]);
	P0.x = 1.; P0.y = 0.;
	for(t = dt; t < 2 * M_PI; t += dt) {
		P.x = f(t); P.y = g(t);
		WRITE(P0, P);
		P0 = P;
	}
	x1 = f1(0.); y1 = g1(0.); x2 = f2(0.); y2 = g2(0.);
	u0 = y2 * x1 - x2 * y1;
	v = x1 * x1 + y1 * y1;
	ml = v / u0;
	P0.x = f(t) - ml * y1; P0.y = g(t) + ml * x1;
	printf("color 3 0 0\n");
	for(t = dt; t < 2 * M_PI; t += dt) {
		x1 = f1(t); y1 = g1(t); x2 = f2(t); y2 = g2(t);
		u = y2 * x1 - x2 * y1;
		v = x1 * x1 + y1 * y1;
		ml = v / u;
		P.x = f(t) - ml * y1; P.y = g(t) + ml * x1;
		if(u0 * u > 0.) WRITE(P0, P);
		P0 = P; u0 = u;
	}
	return 0;
}

		
