#include "planegeometry.h"
#include <math.h>

int m =  2, n = 1;

double f(double t)
{
	return cos(m * t) * cos(n * t);
}

double g(double t)
{
	return cos(m * t) * sin(n * t);
}

double f1(double t)
{
	return -m * sin(m * t) * cos(n * t) - n * cos(m * t) * sin(n * t);
}

double g1(double t)
{
	return -m * sin(m * t) * sin(n * t) + n * cos(m * t) * cos(n * t);
}

double f2(double t)
{
	return -(m * m + n * n) * cos(m * t) * cos(n * t) + 2 * m * n * sin(m * t) * sin(n * t);
}

double g2(double t)
{
	return -(m * m + n * n) * cos(m * t) * sin(n * t) - 2 * m * n * sin(m * t) * cos(n * t);
}

int main(int argc, char *argv[])
{
	POINT P, P0, Q;
	double t, dt = 0.01, x1, y1, x2, y2, v, u, ml, c0, s0, t0;

	if(argc > 1) m = atoi(argv[1]);
	if(argc > 2) n = atoi(argv[2]);
	P0.x = 1.; P0.y = 0.;
	for(t = dt; t < 2 * M_PI; t += dt) {
		P.x = f(t); P.y = g(t);
		WRITE(P0, P);
		P0 = P;
	}
	P0.x = 1.; P0.y = 0.;
	printf("color 3 0 0\n");
	for(t = dt; t < 2 * M_PI; t += dt) {
		x1 = f1(t); y1 = g1(t); x2 = f2(t); y2 = g2(t);
		u = y2 * x1 - x2 * y1;
		v = x1 * x1 + y1 * y1;
		ml = v / u;
		P.x = f(t) - ml * y1; P.y = g(t) + ml * x1;
		WRITE(P0, P);
		P0 = P;
	}
	return 0;
}
