#include "planegeometry.h"
#include <math.h>
#include "uq.h"

void lxl(LINE l, LINE m, double a[])
{
	a[0] = l.a * m.a;
	a[1] = l.a * m.b + l.b * m.a;
	a[2] = l.b * m.b;
	a[3] = l.a * m.c + l.c * m.a;
	a[4] = l.b * m.c + l.c * m.b;
	a[5] = l.c * m.c;
	return;
}

void qxq(double c, double p[], double q[], double d, double r[], double s[], double a[])
{
	a[0] = c * p[0] * q[0] - d * r[0] * s[0];
	a[1] = c * (p[0] * q[1] + p[1] * q[0]) - d * (r[0] * s[1] + r[1] * s[0]);
	a[2] = c * p[2] * q[2] - d * r[2] * s[2];
	a[3] = c * (p[0] * q[3] + p[3] * q[0]) - d * (r[0] * s[3] + r[3] * s[0]);
	a[4] = c * (p[2] * q[4] + p[4] * q[2]) - d * (r[2] * s[4] + r[4] * s[2]);
	a[5] = -c * p[5] * q[5] + d * r[5] * s[5];
	return;
}

int main(int argc, char *argv[])
{
	POINT pt[9];
	line l[8], m[4];
	int i;
	double t[8], a[6], p[6], q[6], r[6], s[6], u[6], v[6], c, d, e;

	if(argc > 8) {
		for(i = 0; i < 8; i++) t[i] = atof(argv[i + 1]);
	}
	else {
		t[0] = 0.; t[1] = 1.; t[2] = 1.6; t[3] = 2.8; t[4] = 3.5; t[5] = 4.2; t[6] = 5.; t[7] = 5.7;
	}
	for(i = 0; i < 8; i++) {
		pt[i].x = cos(t[i]);
		pt[i].y = sin(t[i]);
	}
	pt[8] = pt[0];
	for(i = 0; i < 8; i++) l[i] = pt[i] * pt[i + 1];
	printf("circle 0 0 1.\ncolor 0 0 3\n");
	for(i = 0; i < 7; i += 2) WRITE(l[i]);
	printf("color 0 3 0\n");
	for(i = 1; i < 8; i += 2) WRITE(l[i]);
	/*	m[0] = pt[0] * pt[2];
	m[1] = pt[1] * pt[3];
	m[2] = pt[4] * pt[6];
	m[3] = pt[5] * pt[7];
	*/
	for(i = 0; i < 4; i++) m[i] = pt[i] * pt[i + 4];
	printf("color 3 0 0\n");
	for(i = 0; i < 4; i ++) WRITE(m[i]);
	printf("color 0 3 3\n");
	lxl(l[0], l[2], p);
	lxl(l[4], l[6], q);
	lxl(l[1], l[3], r);
	lxl(l[5], l[7], s);
	for(i = 1, c = 1.; i < 8; i += 2) c *= l[i].c - l[i].a;
	for(i = 0, d = 1.; i < 7; i += 2) d *= l[i].c - l[i].a;
	qxq(c, p, q, d, r, s, a);
	drawq(a);
	lxl(m[0], m[1], u);
	lxl(m[2], m[3], v);
	for(i = 0, e = 1.; i < 4; i ++) e *= m[i].c - m[i].a;
	printf("color 3 0 3\n");
	qxq(e, p, q, d, u, v, a);
	drawq(a);
	printf("color 2 2 0\n");
	qxq(e, r, s, c, u, v, a);
	drawq(a);
	return 0;
}
