#include "planegeometry.h"
#include <math.h>

POINT anisp(POINT O, POINT P, POINT M)
{
	LINE l;
	POINT Q, H;

	l = P * M;
	H = (O | l) * l;
	Q.x = 2. * H.x - P.x;
	Q.y = 2. * H.y - P.y;
	return Q;
}

LINE Pol(POINT O, POINT P)
{
	double r;
	POINT Q;

	r = P.x * P.x + P.y * P.y;
	Q.x = P.x / r;
	Q.y = P.y / r;
	return Q | (O * Q);
}

int main(int argc, char *argv[])
{
	POINT M, N, P, O;
	LINE l;
	double t;

	printf("circle 0 0 1\ncolor 0 0 3\n");
	O.x = O.y = 0.;
	if(argc > 1) M.x = atof(argv[1]);
	else M.x = 2.;
	if(argc > 2) M.y = atof(argv[2]);
	else M.y = -1.;
	if(argc > 3) N.x = atof(argv[3]);
	else N.x = 2.;
	if(argc > 4) N.y = atof(argv[4]);
	else N.y = 1.;
	for(t = 0.; t < 2.* M_PI; t += 0.1) {
		P.x = cos(t);
		P.y = sin(t);
		WRITE(anisp(O, P, M) * anisp(O, P, N));
	}
	printf("color 3 0 0\n");
	WRITE(Pol(O, M));
	WRITE(Pol(O, N));
	return 0;
}
