#include "planegeometry.h"
#include <math.h>

LINE antl(POINT O, LINE p, LINE l)
{
	POINT L, H, P;
	LINE m, q;
	double nr;

	P.x = p.a;
	P.y = p.b;
	if(((nr = P.x * P.x + P.y * P.y) > 1.01) || (nr < 0.99)) {
		nr = sqrt(nr);
		P.x /= nr;
		P.y /= nr;
	}
	L = p * l;
	m = O * L;
	H = (P | m) * m;
	q.a = 2 * H.x - P.x;
	q.b = 2 * H.y - P.y;
	q.c = -1.;
	//WRITE(p);
	//WRITE(q);
	//WRITE(P, H);
	return q;
}

int main(int argc, char *argv[])
{
	POINT O, X, X0;
	LINE l, m, n, p;
	double t;

	O.x = O.y = 0.;
	if(argc > 1) m.a = atof(argv[1]);
	else m.a = 2.;
	if(argc > 2) m.b = atof(argv[2]);
	else m.b = -1.1;
	if(argc > 3) n.a = atof(argv[3]);
	else n.a = 2.;
	if(argc > 4) n.b = atof(argv[4]);
	else n.b = 1.1;
	m.c = n.c = p.c = -1.;
	WRITE(m);
	WRITE(n);
	printf("circle 0 0 1\ncolor 0 0 3\n");
	p.a = 1.; p.b = 0.;
	X0 = antl(O, p, m) * antl(O, p, n);
	for(t = 0.05; t < 2.* M_PI; t += 0.1) {
		p.a = cos(t);
		p.b = sin(t);
		X = antl(O, p, m) * antl(O, p, n);
		WRITE(X0, X);
		X0 = X;
	}
	return 0;
}
