#include "planegeometry.h"
#include <math.h>

double crt(LINE a, LINE b, LINE c, LINE d)
{
	POINT A, B, C, D;
	LINE l;

	l.a = 1.; l.b = 0.; l.c = -3.;
	A = l * a;
	B = l * b;
	C = l * c;
	D = l * d;
	return (A.y - C.y) * (B.y - D.y) /((A.y - D.y) * (B.y - C.y));
}

POINT anisp(POINT O, POINT P, LINE l)
{
	POINT Q, H;

	H = (O | l) * l;
	Q.x = 2. * H.x - P.x;
	Q.y = 2. * H.y - P.y;
	return Q;
}

int main(int argc, char *argv[])
{
	POINT A[4], B[4], P, Q, O;
	LINE a[4];
	double s[4];
	int i;

	if(argc > 1) s[0] = atof(argv[1]);
	else s[0] = 1.;
	if(argc > 2) s[1] = atof(argv[2]);
	else s[1] = 2.;
	if(argc > 3) s[2] = atof(argv[3]);
	else s[2] = 3.;
	if(argc > 4) s[3] = atof(argv[4]);
	else s[3] = 4.;
	O.x = O.y = 0.;
	P.x = 2.; P.y = 0.;
	printf("circle 0 0 1\ncolor 0 0 3\n");
	for(i = 0; i < 4; i++) {
		A[i].x = cos(s[i]);
		A[i].y = sin(s[i]);
		a[i] = P * A[i];
		B[i] = anisp(O, A[i], a[i]);
		WRITE(A[i], B[i]);
	}
	Q.x = -0.8; Q.y = 0.6;
	fprintf(stderr, "%f ?= %f ?= %f\n", crt(a[0], a[1], a[2], a[3]), crt(Q * A[0], Q * A[1], Q * A[2], Q * A[3]), crt(Q * B[0], Q * B[1], Q * B[2], Q * B[3]));
	return 0;
}
