#include "planegeometry.h"
#include <math.h>

POINT anisp(POINT O, POINT P, POINT M)
{
	LINE l;
	POINT Q, H;

	l = P * M;
	H = (O | l) * l;
	Q.x = 2. * H.x - P.x;
	Q.y = 2. * H.y - P.y;
	return Q;
}

int main(int argc, char *argv[])
{
	POINT P, O, X, X0, A[2], B;
	LINE l;
	double t, s[2];
	int i;

	printf("circle 0 0 1\ncolor 0 0 3\n");
	O.x = O.y = 0.;
	P.x = 0.5; P.y = 0.;
	if(argc > 1) s[0] = atof(argv[1]);
	else s[0] = 2.;
	if(argc > 2) s[1] = atof(argv[2]);
	else s[1] = 4.;
	for(i = 0; i < 2; i++) {
		A[i].x = cos(s[i]);
		A[i].y = sin(s[i]);
	}
	B.x = 1.; B.y = 0.;
	X0 = (A[0] * B) * (A[1] * anisp(O, B, P));
	
	for(t = 0.1; t < 2.* M_PI; t += 0.1) {
		B.x = cos(t);
		B.y = sin(t);
		X = (A[0] * B) * (A[1] * anisp(O, B, P));
		WRITE(X0, X);
		X0 = X;
	}
	return 0;
}


		
