#include "planegeometry.h"
#include <math.h>

POINT anisp(POINT O, POINT P, POINT M)
{
	LINE l;
	POINT Q, H;

	l = P * M;
	H = (O | l) * l;
	Q.x = 2. * H.x - P.x;
	Q.y = 2. * H.y - P.y;
	return Q;
}

int main(int argc, char *argv[])
{
	POINT P, Q, R, O, A, P2,Q2, R2;
	double s;

	O.x = O.y = 0.;
	if(argc > 1) s = atof(argv[1]);
	else s = 2.;
	A.x = cos(s);
	A.y = sin(s);
	P.x = 2.; P.y = 0.;
	Q.x = 0.5; Q.y = 2.;
	R.x = 0.5; R.y = 0.375;
	WRITE(P, Q, R);
	printf("circle 0 0 1\ncolor 0 0 3\n");
	P2 = anisp(O, A, P);
	Q2 = anisp(O, A, Q);
	R2 = anisp(O, A, R);
	WRITE(P, P2, A);
	WRITE(Q, Q2, A);
	WRITE(R, R2, A);
	printf("color 3 0 0\n");
	WRITE(P2 * Q2);
	WRITE(P2 * R2);
	WRITE(R2 * Q2);
	return 0;
}
