#include "planegeometry.h"
#include <math.h>

POINT anisp(POINT O, POINT P, POINT M)
{
	LINE l;
	POINT Q, H;

	l = P * M;
	H = (O | l) * l;
	Q.x = 2. * H.x - P.x;
	Q.y = 2. * H.y - P.y;
	return Q;
}

int main(int argc, char *argv[])
{
	POINT P, P2, O, X, X0, A[2], B;
	LINE l;
	double t, s[2];
	int i;

	O.x = O.y = 0.;
	l.a = 1.; l.b = 0.; l.c = -0.7;
	WRITE(l);
	printf("circle 0 0 1\ncolor 0 0 3\n");
	if(argc > 1) s[0] = atof(argv[1]);
	else s[0] = 2.;
	if(argc > 2) s[1] = atof(argv[2]);
	else s[1] = 4.;
	for(i = 0; i < 2; i++) {
		A[i].x = cos(s[i]);
		A[i].y = sin(s[i]);
	}
	P.x = 1.; P.y = 0.;
	B = (P * A[1]) * l;
	P2 = anisp(O, A[0], B);
	X0 = (A[0] * P) * (A[1] * P2);
	for(t = 0.03; t < 2.* M_PI; t += 0.03) {
		P.x = cos(t);
		P.y = sin(t);
		B = (P * A[1]) * l;
		P2 = anisp(O, A[0], B);
		X = (A[0] * P) * (A[1] * P2);
		WRITE(X0, X);
		X0 = X;
	}
	return 0;
}
