#include "planegeometry.h"

void swap(int *a, int *b)
{
    int t;

    t= *a;
    *a= *b;
    *b= t;
}

int factorial(int n, int a[])
{
    int i, j;

    for(i = n-2; i >= 0; i--){
        if(a[i] > a[i+1]) continue;
        for(j = i+2;j < n; j++) if(a[j] < a[i]) break;
        swap(a+i,a+j-1);
        for(i++, n--; i < n;) swap(a+(i++),a+(n--));
        return 1;
    }
    return 0;
}

int sgn(int n, int a[])
{
	int i, j, f = 0;
	for(i = 0; i < n-1; i++)
		for(j = i+1; j < n; j++)
			if(a[i] > a[j]) f++;
	if((f%2) == 0) return 1;
	else return -1;
}


int main()
{
    POINT a[7], p, q;
    LINE l, m;
    int i, j, f[3];

	READ(&l);
	READ(&m);
	for(i = 0; i < 6; i++) READ(a + i);
	a[6] = a[0];
	WRITE(l);
	WRITE(m);
	printf("gray 0.7\n");
	for(i = 0; i < 5; i += 2) {
		for(j = 1; j < 6; j+= 2) WRITE(a[i] * a[j]);
	}
	for(i = 0; i < 3; i++) f[i] = i;
	do {
		if(sgn(3, f) > 0) printf("color 0 0 3\n");
		else printf("color 0 3 0\n");
		p = (a[2 * f[0]] * a[1]) * (a[3] * a[2 * f[2]]);
		q = (a[2 * f[1]] * a[1]) * (a[5] * a[2 * f[2]]);
		WRITE(p * q);
	}while(factorial(3, f) > 0);
	return 0;
}
