#include "planegeometry.h"

double dt(POINT P, LINE l)
{
	double d;

	d = l.a * P.x + l.b * P.y + l.c;
	if(d > 0.) return d;
	else return -d;
}

int main()
{
    POINT A, B, C, L, B2, C2;
	LINE ab, ac, m;
	double dx, dy;

	A.x = 0.; A.y = 0.9;
	B.x = 1.; B.y = 0.;
	C.x = -1.; C.y = 0.;
	WRITE(A, B, C);
	ab = A * B;
	ac = A * C;
	printf("color 0 0 3\n");
	dx = 0.0029; dy = -0.01;
	L.x = A.x + dx; L.y = A.y + dy;
	for(; L.y > 0; L.x += dx, L.y += dy) {
		m = B * L;
		B2 = (L | m) * ac;
		m = C * L;
		C2 = (L | m) * ab;
		m = (B % B2) * (C % C2);
		if(dt(L, m) < 0.01 * dt(A, m)) {
			WRITE(L);
			WRITE(m);
			break;
		}
	}
	return 0;
}

