#include "planegeometry.h"

double dt(POINT P, LINE l)
{
	double d;

	d = l.a * P.x + l.b * P.y + l.c;
	if(d > 0.) return d;
	else return -d;
}

int main()
{
    POINT A, B, C, L, B2, C2;
	LINE ab, ac, m;
	double dx, dy;

	A.x = 0.05; A.y = 0.93;
	B.x = 1.; B.y = 0.;
	C.x = -1.; C.y = 0.;
	WRITE(A, B, C);
	ab = A * B;
	ac = A * C;
	printf("color 0 0 3\n");
	for(L.x = -0.5; L.x < 0.5; L.x += 0.01) {
		for(L.y = 0.5; L.y < 1.5; L.y += 0.01) {
			m = B * L;
			B2 = (L | m) * ac;
			m = C * L;
			C2 = (L | m) * ab;
			m = (B % B2) * (C % C2);
			if(dt(L, m) < 0.001 * dt(A, m)) {
				WRITE(L);
				break;
			}
		}
	}
	return 0;
}

