#include "planegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
    POINT A, B, C, D, L, H, P, Q, S, S0;
	LINE ab, bc, ac, m, m0;
	CIRC crl;
	double r, t, dt = 0.1;

	if(argc > 1) A.x = atof(argv[1]);
	else A.x = 0.05;
	if(argc > 2) A.y = atof(argv[2]);
	else A.y = 0.9;
	B.x = 1.; B.y = 0.;
	C.x = -1.; C.y = 0.;
	WRITE(A, B, C);
	bc = B * C;
	ac = A * C;
	D = (m = A | bc) * bc;
	H = m * (B | ac);
	r = sqrt((H + A) * (H + D));
	//crl.c = H; crl.r = r;
	//WRITE(crl);
	printf("color 0 0 3\n");
	L.x = H.x + r; L.y = H.y;
	P = (L | (A * L)) * bc;
	Q = (L | (B * L)) * ac;
	m0 = P * Q;
	L.x = H.x + r * cos(dt); L.y = H.y + r * sin(dt);
	P = (L | (A * L)) * bc;
	Q = (L | (B * L)) * ac;
	m = P * Q;
	S0 = m0 * m;
	m0  = m;
	for(t = 2. * dt; t < 6.4; t += dt) {
		L.x = H.x + r * cos(t);
		L.y = H.y + r * sin(t);
		P = (L | (A * L)) * bc;
		Q = (L | (B * L)) * ac;
		m = P * Q;
		WRITE(m);
		S = m * m0;
		//WRITE(S0, S);
		m0 = m;
		S0 = S;
	}
	if(argc > 3) t = atof(argv[3]);
	else t = 0.5;	
	printf("color 3 0 0\n");
	ab = A * B;
	L.x = H.x + r * cos(t);
	L.y = H.y + r * sin(t);
	P = (L | (A * L)) * bc;
	Q = A % P;
	crl.c = Q; crl.r = Q + A;
	WRITE(crl);
	P = (L | (B * L)) * ac;
	Q = B % P;
	crl.c = Q; crl.r = Q + B;
	WRITE(crl);
	P = (L | (C * L)) * ab;
	Q = C % P;
	crl.c = Q; crl.r = Q + C;
	WRITE(crl);
	return 0;
}
