#include "planegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
    POINT A, B, C, D, L, H, P, Q, S, S0;
	LINE ab, bc, ac, m, m0;
	double r, t, dt = 0.01, r0;

	if(argc > 1) A.x = atof(argv[1]);
	else A.x = 0.05;
	if(argc > 2) A.y = atof(argv[2]);
	else A.y = 0.4;
	B.x = 1.; B.y = -0.5;
	C.x = -1.; C.y = -0.5;
	bc = B * C;
	ac = A * C;
	D = (m = A | bc) * bc;
	H = m * (B | ac);
	r = sqrt((H + A) * (H + D));
	for(t = 0.; t < 6.4; t += dt) {
		for(r0 = r; r0 > 0.1 * r; r0 *= 0.95) {
			L.x = H.x + r0 * cos(t);
			L.y = H.y + r0 * sin(t);
			P = (L | (A * L)) * bc;
			Q = (L | (B * L)) * ac;
			m = P * Q;
			S.x = -m.a / m.c;
			S.y = -m.b / m.c;
			WRITE(S);
		}
	}
	printf("color 0 0 3\n");
	WRITE(A, B, C);
	printf("color 3 0 0\ncircle 0. 0. 1.\n");
	return 0;
}
