#include "planegeometry.h"
#include <math.h>
#include "uq.h"

int main(int argc, char *argv[])
{
	POINT A, B, C, D, E, G, P, Q, T;
	LINE l, m;
	int i;
	double t, qd[6];

	qd[0] = 1.; qd[2] = 4.; qd[5] = -4.;
	qd[1] = qd[3] = qd[4] = 0.;
	drawq(qd);
	A.x = 2. * cos(0.5 * M_PI); A.y = sin(0.5 * M_PI);
	B.x = 2. * cos(1.3 * M_PI); B.y = sin(1.3 * M_PI);
	C.x = 2. * cos(1.8 * M_PI); C.y = sin(1.8 * M_PI);
	WRITE(l = A * B); WRITE(m = A * C);
	P.x = 2. * cos(0.3 * M_PI); P.y = sin(0.3 * M_PI);
	Q.x = 2. * cos(2.8 * M_PI); Q.y = sin(2.8 * M_PI);
	T = (B * P) * (C * Q);
	printf("gray 0.8\n");
	WRITE(B, P); WRITE(C, Q);
	printf("color 0 0 3\n");
	for(i = 1; i < argc; i++) {
		t = atof(argv[i]);
		G.x = 2 * cos(t);
		G.y = sin(t);
		D = m * (P * G);
		WRITE(P, D);
		WRITE(G, D);
		E = l * (T * D);
		WRITE(D, T); WRITE(T, E);
		WRITE(Q, E);
		WRITE(G, E);
	}
	return 0;
}
