#include "planegeometry.h"
#include <math.h>
#include <unistd.h>

typedef struct {
    long r, w;
} AGI;

AGI operator *(AGI x, AGI y)
{
	AGI z;

	z.r = x.r * y.r - x.w * y.w;
	z.w = (x.r - x.w) * y.w + x.w * y.r;
	return z;
}

int getl(char *s)
{
    static int f = 0;
    int l = 0;
    if(f == 1) return -1;
    for(; l < 20; s++, l++) {
        if(read(0, s, 1) > 0) {
            if(*s == '\n') {
                *s = '\0';
                return l;
            }
        }
        else {
            if(l == 0) return -1;
                f = 1;
                *s = '\0';
                return l;
        }
    }
    return 20;
}

AGI atoagi(char *s)
{
    AGI z;
    char *t;
    int sgn = 1;

    t = s;
    if(*t == '-' ) {
		t++;
		if(*t == 'w') {
			sgn = -1;
			s = t;
		}
    }
    for(; *t != 0; t++) {
		if(*t == '+' || *t == '-' || *t == 'w') break;
    }
    if(*t == 0) {
		z.w = 0;
		sgn = 0;
    }
    else if(*t == '-') sgn = -1;
    if(*t == 'w' && s == t) z.r = 0;
    else {
		*t = 0;
		z.r = atoi(s);
    }
    if(sgn == 0) return z;
    if(*(++t) == 'w') t++;
    for(s = t; ; t++) if(*t == 0) break;
    if(s == t) z.w = sgn;
    else z.w = sgn * atoi(s);
    return z;
}

int main(int argc, char *argv[])
{
	int i, j, u, v, n = 10;
	double r = 2., sq3 = sqrt(3.);
	LINE a, b, c;
	POINT P;
	char s[20];
	AGI z, ut;

	if(argc > 1) n = atoi(argv[1]);
	a.a = 0; a.b = 2.;
	b.a = sq3; b.b = 1.;
	c.a = sq3; c.b = -1.;
	printf("gray 0.7\n");
	for(i = -10; i < 12; i++) {
		a.c = b.c = c.c = i * sq3;
		WRITE(a); WRITE(b); WRITE(c);
	}
	printf("color 3 0 0 \ndisk 0 0 0.1\n");
	printf("color 0 0 3\n");
	ut.r = ut.w = 1;
	for(i = 0; i < n; i++) {
		getl(s);
		z = atoagi(s);
		for(j = 0; ; j++) {
			P.x = z.r - 0.5 * z.w;
			P.y = 0.5 * sq3 * z.w;
			//WRITE(P);
			printf("disk %f %f 0.1\n", P.x, P.y);
			if(j > 4) break;
			z = z * ut;
		}
	}
	return 0;
}
