#include "planegeometry.h"
#include <math.h>

int main(int argc, char *argv[])
{
	int i;
	double t, x, y, x0, y0, s;
	LINE l[3];
	POINT P[3], Q[3];

	x0 = 3; y0 = 0;
	for(t = 0; t < 2 * M_PI; t += 0.1) {
		x = 2 * cos(t) + cos(2 * t);
		y = 2 * sin(t) - sin(2 * t);
		printf("connect %f %f %f %f\n", x, y, x0, y0);
		x0 = x; y0 = y;
	}
	if(argc < 4) exit(0);
	printf("color 0 0 3\n");
	for(i = 0; i < 3; i++) {
		t = atof(argv[i + 1]);
		x = cos(t);
		y = sin(t);
		l[i].a = sin(t / 2.); l[i].b = cos(t / 2.);
		l[i].c = -l[i].a * x - l[i].b * y;
		P[i].x = 2. * x + cos(2. * t);
		P[i].y = 2 * y - sin(2 * t);
		WRITE(P[i]);
	}
	for(i = 0; i < 3; i++) Q[i] = l[(i + 1) % 3] * l[(i + 2) % 3];
	printf("color 3 0 0\n");
	WRITE(Q[0], Q[1], Q[2]);
	return 0;
}
