#include "planegeometry.h"
#include <math.h>

POINT anop(POINT A)
{
	POINT B;
	double a, b;

	a = A.y / (A.x + 2.5);
	b = a * A.x - A.y;
	B.x = 2. * a * b / (a * a + 1.) - A.x;
	B.y = a * (B.x - A.x) + A.y;
	return B;
}

int main(int argc,  char *argv[])
{
	POINT A, B, C, D, E, F;
	double t;

	if(argc > 1) t = atof(argv[1]);
	else t = 1.545;
	printf("circle 0. 0. 1.\n");
	A.x = cos(t);
	A.y = sin(t);
	B = anop(A);
	printf("color 0 0 3\n");
	WRITE(A * B);
	/*
	WRITE(A);
	WRITE(B);
	*/
	C.x = cos(3.2); C.y = sin(3.2);
	F = anop(C);
	D.x = cos(3.8); D.y = sin(3.8);
	E = anop(D);
	WRITE(C * F);
	WRITE(D * E);
	printf("color 0 3 0\n");
	WRITE(A * D);
	WRITE(B * C);
	WRITE(E * F);
	printf("color 3 0 0\n");
	WRITE(A * F);
	WRITE(B * E);
	WRITE(C * D);
	return 0;
}
