#include "planegeometry.h"
#include <math.h>

POINT anop(POINT A)
{
	POINT B;
	double a, b;

	a = A.x / (A.y - 2.5);
	b = a * A.y - A.x;
	B.y = 2. * a * b / (a * a + 1.) - A.y;
	B.x = a * (B.y - A.y) + A.x;
	return B;
}

int main(int argc,  char *argv[])
{
	POINT A, B, C, D, E, F;
	double t;

	if(argc > 1) t = atof(argv[1]);
	else t = -0.025;
	printf("circle 0. 0. 1.\n");
	A.x = cos(t);
	A.y = sin(t);
	B = anop(A);
	printf("color 0 0 3\n");
	WRITE(A * B);
	/*
	WRITE(A);
	WRITE(B);
	*/
	C.x = cos(1.63); C.y = sin(1.63);
	F = anop(C);
	D.x = cos(2.23); D.y = sin(2.23);
	E = anop(D);
	WRITE(C * F);
	WRITE(D * E);
	printf("color 0 3 0\n");
	WRITE(A * D);
	WRITE(B * C);
	WRITE(E * F);
	printf("color 3 0 0\n");
	WRITE(A * F);
	WRITE(B * E);
	WRITE(C * D);
	printf("gray 0.5\n");
	WRITE(((A * B) * (D * E)) *((B * C) * (E * F)));
	printf("color 0 3 3\n");
	WRITE(((A * B) * (E * F)) *((B * C) * (E * D)));
	return 0;
}
