#include "planegeometry.h"

int main(int argc, char *argv[])
{
	POINT P0, P, Q, F;
	LINE l;
	double t;

	P0.x = -2, P0.y = 4.;
	for(t = -1.9; t < 2.; t += 0.1) {
		P.x = t, P.y = t * t;
		WRITE(P0, P);
		P0 = P;
	}
	if(argc > 2) {
		F.x = atof(argv[1]); F.y = atof(argv[2]);
	}
	else {
		F.x = 0., F.y = -1.;
	}
	printf("disk %f %f 0.03\n", F.x, F.y);
	printf("color 0 0 3\n");
	for(t = -2.; t < 2; t += 0.02) {
		l.a = 2. * t; l.b = -1.; l.c = -t * t;
		//WRITE(l);
		Q = (F | l) * l;
		printf("disk %f %f 0.02\n", Q.x, Q.y);
	}
	return 0;
}
